/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter;

import java.util.concurrent.TimeUnit;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterType;
import org.infinispan.counter.impl.BaseCounterTest;
import org.infinispan.manager.EmbeddedCacheManager;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="counter.LazyCacheStartTest")
public class LazyCacheStartTest
extends BaseCounterTest {
    public void testLazyStart() {
        for (EmbeddedCacheManager manager : this.cacheManagers) {
            AssertJUnit.assertFalse((boolean)manager.isRunning("org.infinispan.COUNTER"));
        }
        this.counterManager(0).defineCounter("some-counter", CounterConfiguration.builder((CounterType)CounterType.WEAK).build());
        for (EmbeddedCacheManager manager : this.cacheManagers) {
            this.eventually(() -> "counter cache didn't start in " + manager.getTransport().getAddress(), () -> manager.isRunning("org.infinispan.COUNTER"), 30L, TimeUnit.SECONDS);
        }
    }

    @Override
    protected int clusterSize() {
        return 3;
    }
}

