/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.configuration;

import java.util.Collections;
import java.util.List;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.configuration.serializing.SerializedWith;
import org.infinispan.counter.configuration.AbstractCounterConfiguration;
import org.infinispan.counter.configuration.CounterConfigurationSerializer;
import org.infinispan.counter.configuration.Reliability;
import org.infinispan.counter.logging.Log;

@SerializedWith(value=CounterConfigurationSerializer.class)
public class CounterManagerConfiguration {
    private static final Log log = (Log)LogFactory.getLog(CounterManagerConfiguration.class, Log.class);
    static final AttributeDefinition<Reliability> RELIABILITY = AttributeDefinition.builder((String)"reliability", (Object)((Object)Reliability.AVAILABLE)).validator(value -> {
        if (value == null) {
            throw log.invalidReliabilityMode();
        }
    }).immutable().build();
    static final AttributeDefinition<Integer> NUM_OWNERS = AttributeDefinition.builder((String)"numOwners", (Object)2).validator(value -> {
        if (value < 1) {
            throw log.invalidNumOwners((int)value);
        }
    }).immutable().build();
    private final AttributeSet attributes;
    private final List<? extends AbstractCounterConfiguration> counters;

    CounterManagerConfiguration(AttributeSet attributes, List<? extends AbstractCounterConfiguration> counters) {
        this.attributes = attributes;
        this.counters = counters;
    }

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(CounterManagerConfiguration.class, new AttributeDefinition[]{NUM_OWNERS, RELIABILITY});
    }

    public int numOwners() {
        return (Integer)this.attributes.attribute(NUM_OWNERS).get();
    }

    public Reliability reliability() {
        return (Reliability)((Object)this.attributes.attribute(RELIABILITY).get());
    }

    AttributeSet attributes() {
        return this.attributes;
    }

    public List<AbstractCounterConfiguration> counters() {
        return Collections.unmodifiableList(this.counters);
    }
}

