/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock.jmx;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.infinispan.Cache;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.jmx.PerThreadMBeanServerLookup;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.functional.FunctionalTestUtils;
import org.infinispan.lock.BaseClusteredLockTest;
import org.infinispan.lock.api.ClusteredLock;
import org.infinispan.lock.api.ClusteredLockManager;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="clusteredLock.jmx.ClusteredLockJmxTest")
public class ClusteredLockJmxTest
extends BaseClusteredLockTest {
    private static final String LOCK_NAME = "ClusteredLockJmxTest";

    public void testForceRelease() throws Exception {
        ClusteredLockManager clm = this.clusteredLockManager(0);
        AssertJUnit.assertTrue((boolean)this.clusteredLockManager(0).defineLock(LOCK_NAME));
        ClusteredLock lock = clm.get(LOCK_NAME);
        AssertJUnit.assertTrue((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)lock.tryLock())));
        AssertJUnit.assertTrue((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)lock.isLocked())));
        AssertJUnit.assertTrue((boolean)((Boolean)this.executeClusteredLockNameArgOperation(0, "forceRelease", LOCK_NAME)));
        AssertJUnit.assertFalse((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)lock.isLocked())));
    }

    public void testRemove() throws Exception {
        ClusteredLockManager clm = this.clusteredLockManager(0);
        AssertJUnit.assertTrue((boolean)clm.defineLock(LOCK_NAME));
        AssertJUnit.assertFalse((boolean)clm.defineLock(LOCK_NAME));
        AssertJUnit.assertTrue((boolean)((Boolean)this.executeClusteredLockNameArgOperation(0, "remove", LOCK_NAME)));
        AssertJUnit.assertFalse((boolean)((Boolean)this.executeClusteredLockNameArgOperation(0, "remove", LOCK_NAME)));
        AssertJUnit.assertTrue((boolean)clm.defineLock(LOCK_NAME));
    }

    public void testIsDefined() throws Exception {
        AssertJUnit.assertFalse((boolean)((Boolean)this.executeClusteredLockNameArgOperation(0, "isDefined", LOCK_NAME)));
        AssertJUnit.assertTrue((boolean)this.clusteredLockManager(0).defineLock(LOCK_NAME));
        AssertJUnit.assertTrue((boolean)((Boolean)this.executeClusteredLockNameArgOperation(0, "isDefined", LOCK_NAME)));
    }

    public void testIsLocked() throws Exception {
        AssertJUnit.assertFalse((boolean)((Boolean)this.executeClusteredLockNameArgOperation(0, "isLocked", LOCK_NAME)));
        ClusteredLockManager clm = this.clusteredLockManager(0);
        AssertJUnit.assertTrue((boolean)clm.defineLock(LOCK_NAME));
        AssertJUnit.assertFalse((boolean)((Boolean)this.executeClusteredLockNameArgOperation(0, "isLocked", LOCK_NAME)));
        ClusteredLock lock = clm.get(LOCK_NAME);
        AssertJUnit.assertTrue((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)lock.tryLock())));
        AssertJUnit.assertTrue((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)lock.isLocked())));
        AssertJUnit.assertTrue((boolean)((Boolean)this.executeClusteredLockNameArgOperation(0, "isLocked", LOCK_NAME)));
    }

    @AfterMethod(alwaysRun=true)
    protected void clearContent() throws Throwable {
        super.clearContent();
        this.findCache("org.infinispan.LOCKS").ifPresent(Cache::clear);
    }

    @Override
    protected int clusterSize() {
        return 2;
    }

    @Override
    protected GlobalConfigurationBuilder configure(int nodeId) {
        GlobalConfigurationBuilder builder = GlobalConfigurationBuilder.defaultClusteredBuilder();
        builder.globalJmxStatistics().enable().mBeanServerLookup((MBeanServerLookup)new PerThreadMBeanServerLookup());
        return builder;
    }

    private Optional<Cache<?, ?>> findCache(String cacheName) {
        return Optional.ofNullable(this.manager(0).getCache(cacheName, false));
    }

    private <T> T executeClusteredLockNameArgOperation(int index, String operationName, String arg) {
        MBeanServer server = PerThreadMBeanServerLookup.getThreadMBeanServer();
        try {
            return (T)server.invoke(this.clusteredLockObjectName(index), operationName, new Object[]{arg}, new String[]{String.class.getName()});
        }
        catch (InstanceNotFoundException | MBeanException | ReflectionException e) {
            throw new RuntimeException(e);
        }
    }

    private ObjectName clusteredLockObjectName(int managerIndex) {
        String domain = this.manager(managerIndex).getCacheManagerConfiguration().globalJmxStatistics().domain();
        return TestingUtil.getCacheManagerObjectName((String)domain, (String)"DefaultCacheManager", (String)"ClusteredLockManager");
    }
}

