/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock.impl.manager;

import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.lock.api.ClusteredLock;
import org.infinispan.lock.api.ClusteredLockConfiguration;
import org.infinispan.lock.api.ClusteredLockManager;
import org.infinispan.lock.configuration.ClusteredLockManagerConfiguration;
import org.infinispan.lock.exception.ClusteredLockException;
import org.infinispan.lock.impl.entries.ClusteredLockKey;
import org.infinispan.lock.impl.entries.ClusteredLockState;
import org.infinispan.lock.impl.entries.ClusteredLockValue;
import org.infinispan.lock.impl.lock.ClusteredLockImpl;
import org.infinispan.lock.impl.manager.CacheHolder;
import org.infinispan.lock.logging.Log;
import org.infinispan.util.ByteString;
import org.infinispan.util.function.SerializableBiFunction;

@Scope(value=Scopes.GLOBAL)
@MBean(objectName="ClusteredLockManager", description="Component to manage clustered locks")
public class EmbeddedClusteredLockManager
implements ClusteredLockManager {
    public static final String OBJECT_NAME = "ClusteredLockManager";
    private static final long WAIT_CACHES_TIMEOUT = TimeUnit.SECONDS.toNanos(15L);
    private static final Log log = (Log)LogFactory.getLog(EmbeddedClusteredLockManager.class, Log.class);
    private static final boolean trace = log.isTraceEnabled();
    public static final String FORCE_RELEASE = "forceRelease";
    public static final String REMOVE = "remove";
    public static final String IS_DEFINED = "isDefined";
    public static final String IS_LOCKED = "isLocked";
    private final ConcurrentHashMap<String, ClusteredLock> locks = new ConcurrentHashMap();
    private final CompletableFuture<CacheHolder> cacheHolderFuture;
    private final ClusteredLockManagerConfiguration config;
    private ScheduledExecutorService scheduledExecutorService;
    private Executor executor;
    private AdvancedCache<ClusteredLockKey, ClusteredLockValue> cache;

    public EmbeddedClusteredLockManager(CompletableFuture<CacheHolder> cacheHolderFuture, ClusteredLockManagerConfiguration config) {
        this.cacheHolderFuture = cacheHolderFuture;
        this.config = config;
    }

    @Inject
    public void injectDep(@ComponentName(value="org.infinispan.executors.timeout") ScheduledExecutorService scheduledExecutorService, @ComponentName(value="org.infinispan.executors.async") Executor executor) {
        this.scheduledExecutorService = scheduledExecutorService;
        this.executor = executor;
    }

    public boolean defineLock(String name) {
        ClusteredLockConfiguration configuration = new ClusteredLockConfiguration();
        if (trace) {
            log.tracef("LOCK[%s] defineLock with default configuration has been called %s", name, configuration);
        }
        return this.defineLock(name, configuration);
    }

    public boolean defineLock(String name, ClusteredLockConfiguration configuration) {
        if (trace) {
            log.tracef("LOCK[%s] defineLock has been called %s", name, configuration);
        }
        CacheHolder cacheHolder = EmbeddedClusteredLockManager.extractCacheHolder(this.cacheHolderFuture);
        this.cache = cacheHolder.getClusteredLockCache();
        ClusteredLockKey key = new ClusteredLockKey(ByteString.fromString((String)name));
        ClusteredLockValue clusteredLockValue = (ClusteredLockValue)this.cache.putIfAbsent((Object)key, (Object)ClusteredLockValue.INITIAL_STATE);
        this.locks.putIfAbsent(name, new ClusteredLockImpl(name, key, this.cache, this));
        return clusteredLockValue == null;
    }

    public ClusteredLock get(String name) {
        if (trace) {
            log.tracef("LOCK[%s] get has been called", name);
        }
        if (this.cache == null) {
            this.cache = EmbeddedClusteredLockManager.extractCacheHolder(this.cacheHolderFuture).getClusteredLockCache();
        }
        return this.locks.computeIfAbsent(name, this::createLock);
    }

    private ClusteredLockImpl createLock(String lockName) {
        ClusteredLockConfiguration configuration = this.getConfiguration(lockName);
        if (configuration == null) {
            throw new ClusteredLockException(String.format("Lock %s does not exist", lockName));
        }
        ClusteredLockKey key = new ClusteredLockKey(ByteString.fromString((String)lockName));
        this.cache.putIfAbsent((Object)key, (Object)ClusteredLockValue.INITIAL_STATE);
        ClusteredLockImpl lock = new ClusteredLockImpl(lockName, key, this.cache, this);
        return lock;
    }

    public ClusteredLockConfiguration getConfiguration(String name) {
        if (trace) {
            log.tracef("LOCK[%s] getConfiguration has been called", name);
        }
        CacheHolder cacheHolder = EmbeddedClusteredLockManager.extractCacheHolder(this.cacheHolderFuture);
        this.cache = cacheHolder.getClusteredLockCache();
        if (this.cache.containsKey((Object)new ClusteredLockKey(ByteString.fromString((String)name)))) {
            return new ClusteredLockConfiguration();
        }
        if (this.config.locks().containsKey(name)) {
            return new ClusteredLockConfiguration();
        }
        throw new ClusteredLockException(String.format("Lock %s does not exist", name));
    }

    @ManagedOperation(description="Returns true if the lock is defined", displayName="Is Lock Defined", name="isDefined")
    public boolean isDefined(String name) {
        if (trace) {
            log.tracef("LOCK[%s] isDefined has been called", name);
        }
        if (this.cache == null) {
            this.cache = EmbeddedClusteredLockManager.extractCacheHolder(this.cacheHolderFuture).getClusteredLockCache();
        }
        return this.cache.containsKey((Object)new ClusteredLockKey(ByteString.fromString((String)name)));
    }

    public CompletableFuture<Boolean> remove(String name) {
        if (trace) {
            log.tracef("LOCK[%s] remove has been called", name);
        }
        CacheHolder cacheHolder = EmbeddedClusteredLockManager.extractCacheHolder(this.cacheHolderFuture);
        AdvancedCache clusteredLockCache = cacheHolder.getClusteredLockCache();
        ClusteredLockImpl clusteredLock = (ClusteredLockImpl)this.locks.get(name);
        if (clusteredLock != null) {
            clusteredLock.stop();
            this.locks.remove(name);
        }
        return clusteredLockCache.removeAsync((Object)new ClusteredLockKey(ByteString.fromString((String)name))).thenApply(value -> value != null);
    }

    @ManagedOperation(description="Removes the lock from the cluster. The lock has to be recreated to access next time.", displayName="Remove Clustered Lock", name="remove")
    public boolean removeSync(String name) {
        if (trace) {
            log.tracef("LOCK[%s] remove sync has been called", name);
        }
        CacheHolder cacheHolder = EmbeddedClusteredLockManager.extractCacheHolder(this.cacheHolderFuture);
        AdvancedCache clusteredLockCache = cacheHolder.getClusteredLockCache();
        ClusteredLockImpl clusteredLock = (ClusteredLockImpl)this.locks.get(name);
        if (clusteredLock != null) {
            clusteredLock.stop();
            this.locks.remove(name);
        }
        return clusteredLockCache.remove((Object)new ClusteredLockKey(ByteString.fromString((String)name))) != null;
    }

    public CompletableFuture<Boolean> forceRelease(String name) {
        if (trace) {
            log.tracef("LOCK[%s] forceRelease has been called", name);
        }
        CompletableFuture future = this.cache.computeIfPresentAsync((Object)new ClusteredLockKey(ByteString.fromString((String)name)), (SerializableBiFunction & Serializable)(k, v) -> ClusteredLockValue.INITIAL_STATE);
        return future.thenApply(clusteredLockValue -> clusteredLockValue != null && clusteredLockValue.getState() == ClusteredLockState.RELEASED);
    }

    @ManagedOperation(description="Forces a release of the lock if such exist", displayName="Release Clustered Lock", name="forceRelease")
    public boolean forceReleaseSync(String name) {
        if (trace) {
            log.tracef("LOCK[%s] forceRelease sync has been called", name);
        }
        return this.forceRelease(name).join();
    }

    @ManagedOperation(description="Returns true if the lock exists and is acquired", displayName="Is Locked", name="isLocked")
    public boolean isLockedSync(String name) {
        ClusteredLockValue clusteredLockValue;
        if (trace) {
            log.tracef("LOCK[%s] isLocked sync has been called", name);
        }
        return (clusteredLockValue = (ClusteredLockValue)this.cache.get((Object)new ClusteredLockKey(ByteString.fromString((String)name)))) != null && clusteredLockValue.getState() == ClusteredLockState.ACQUIRED;
    }

    private static CacheHolder extractCacheHolder(CompletableFuture<CacheHolder> future) {
        try {
            return future.get(WAIT_CACHES_TIMEOUT, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.fatal(e);
            throw new IllegalStateException("Clustered lock cache could not be started", e);
        }
        catch (ExecutionException | TimeoutException e) {
            log.fatal(e);
            throw new IllegalStateException("Clustered lock cache could not be started", e);
        }
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    public void execute(Runnable runnable) {
        this.executor.execute(runnable);
    }

    public String toString() {
        return "EmbeddedClusteredLockManager{, address=" + this.cache.getCacheManager().getAddress() + ", locks=" + this.locks + '}';
    }
}

