/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.infinispan.functional.FunctionalTestUtils;
import org.infinispan.lock.BaseClusteredLockTest;
import org.infinispan.lock.api.ClusteredLock;
import org.infinispan.lock.api.ClusteredLockConfiguration;
import org.infinispan.lock.api.ClusteredLockManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@CleanupAfterMethod
@Test(groups={"functional"}, testName="clusteredLock.ClusteredLockWith2NodesTest")
public class ClusteredLockWith2NodesTest
extends BaseClusteredLockTest {
    private static final String LOCK_NAME = "ClusteredLockWith2NodesTest";

    @Override
    protected int clusterSize() {
        return 2;
    }

    public void testTryLockAndKillCoordinator() {
        this.doTest(0, 1);
    }

    @Test
    public void testTryLockAndKillNode() {
        this.doTest(1, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTest(int killedNode, int survivingNode) {
        ClusteredLockManager m1 = this.clusteredLockManager(0);
        m1.defineLock(LOCK_NAME, new ClusteredLockConfiguration());
        ClusteredLock firstLockOwner = this.clusteredLockManager(killedNode).get(LOCK_NAME);
        ClusteredLock secondLockOwner = this.clusteredLockManager(survivingNode).get(LOCK_NAME);
        Boolean acquired = (Boolean)FunctionalTestUtils.await((CompletableFuture)firstLockOwner.tryLock());
        if (!acquired.booleanValue()) {
            AssertJUnit.fail((String)"Manager 0 could not acquire the lock");
        }
        try {
            TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.manager(killedNode)});
            FunctionalTestUtils.await((CompletableFuture)secondLockOwner.tryLock(1L, TimeUnit.SECONDS));
        }
        finally {
            ClusteredLockManager clusteredLockManager = this.clusteredLockManager(survivingNode);
            FunctionalTestUtils.await((CompletableFuture)clusteredLockManager.remove(LOCK_NAME));
        }
    }
}

