/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock;

import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.functional.FunctionalTestUtils;
import org.infinispan.lock.BaseClusteredLockSplitBrainTest;
import org.infinispan.lock.EmbeddedClusteredLockManagerFactory;
import org.infinispan.lock.api.ClusteredLock;
import org.infinispan.lock.api.ClusteredLockManager;
import org.infinispan.lock.configuration.Reliability;
import org.infinispan.manager.EmbeddedCacheManager;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="clusteredLock.AvailableReliabilitySplitBrainTest")
public class AvailableReliabilitySplitBrainTest
extends BaseClusteredLockSplitBrainTest {
    public AvailableReliabilitySplitBrainTest() {
        this.reliability = Reliability.AVAILABLE;
        this.numOwner = 6;
        this.cacheMode = CacheMode.DIST_SYNC;
    }

    @Override
    protected String getLockName() {
        return "AvailableReliabilitySplitBrainTest";
    }

    @Test
    public void testLockCreationWhenPartitionHappening() {
        ClusteredLockManager clusteredLockManager = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)((EmbeddedCacheManager)this.getCacheManagers().get(0)));
        FunctionalTestUtils.await((CompletableFuture)clusteredLockManager.remove(this.getLockName()));
        this.splitCluster(new int[][]{{0, 1, 2}, {3, 4, 5}});
        for (EmbeddedCacheManager cm : this.getCacheManagers()) {
            ClusteredLockManager clm = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)cm);
            clm.defineLock(this.getLockName());
        }
    }

    @Test
    public void testLockUseAfterPartitionWithoutMajority() {
        ClusteredLockManager clm0 = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)((EmbeddedCacheManager)this.getCacheManagers().get(0)));
        ClusteredLockManager clm1 = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)((EmbeddedCacheManager)this.getCacheManagers().get(1)));
        ClusteredLockManager clm2 = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)((EmbeddedCacheManager)this.getCacheManagers().get(2)));
        ClusteredLockManager clm3 = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)((EmbeddedCacheManager)this.getCacheManagers().get(3)));
        ClusteredLockManager clm4 = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)((EmbeddedCacheManager)this.getCacheManagers().get(4)));
        ClusteredLockManager clm5 = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)((EmbeddedCacheManager)this.getCacheManagers().get(5)));
        clm0.defineLock(this.getLockName());
        AssertJUnit.assertTrue((boolean)clm0.isDefined(this.getLockName()));
        this.splitCluster(new int[][]{{0, 1, 2}, {3, 4, 5}});
        this.partition(0).assertDegradedMode();
        this.partition(1).assertDegradedMode();
        ClusteredLock lock0 = clm0.get(this.getLockName());
        ClusteredLock lock1 = clm1.get(this.getLockName());
        ClusteredLock lock2 = clm2.get(this.getLockName());
        ClusteredLock lock3 = clm3.get(this.getLockName());
        ClusteredLock lock4 = clm4.get(this.getLockName());
        ClusteredLock lock5 = clm5.get(this.getLockName());
        Arrays.asList(lock0, lock1, lock2, lock3, lock4, lock5).forEach(lock -> {
            AssertJUnit.assertNotNull((Object)lock);
            Boolean tryLock = (Boolean)FunctionalTestUtils.await((CompletableFuture)lock.tryLock());
            AssertJUnit.assertTrue((boolean)tryLock);
            FunctionalTestUtils.await((CompletableFuture)lock.unlock());
        });
    }
}

