/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock;

import java.util.concurrent.CompletableFuture;
import org.infinispan.functional.FunctionalTestUtils;
import org.infinispan.lock.BaseClusteredLockTest;
import org.infinispan.lock.api.ClusteredLock;
import org.infinispan.lock.api.ClusteredLockConfiguration;
import org.infinispan.lock.api.ClusteredLockManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="clusteredLock.ClusteredLockKillingNodesTest")
public class ClusteredLockKillingNodesTest
extends BaseClusteredLockTest {
    protected static final String LOCK_NAME = "ClusteredLockKillingNodesTest";

    @BeforeMethod(alwaysRun=true)
    public void createLock() throws Throwable {
        ClusteredLockManager m1 = this.clusteredLockManager(0);
        m1.defineLock(LOCK_NAME, new ClusteredLockConfiguration());
    }

    @AfterMethod(alwaysRun=true)
    protected void destroyLock() {
        ClusteredLockManager clusteredLockManager = this.clusteredLockManager(0);
        FunctionalTestUtils.await((CompletableFuture)clusteredLockManager.remove(LOCK_NAME));
    }

    @Test
    public void testLockWithAcquisitionAndKill() throws Throwable {
        ClusteredLock firstLockOwner = this.clusteredLockManager(1).get(LOCK_NAME);
        ClusteredLock secondLockOwner = this.clusteredLockManager(2).get(LOCK_NAME);
        StringBuilder value = new StringBuilder();
        FunctionalTestUtils.await((CompletableFuture)firstLockOwner.lock().thenRun(() -> {
            TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.manager(1)});
            FunctionalTestUtils.await((CompletableFuture)secondLockOwner.lock().thenRun(() -> value.append("hello")));
        }));
        AssertJUnit.assertEquals((String)value.toString(), (String)"hello");
    }
}

