/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock.configuration;

import java.util.Map;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.lock.configuration.Attribute;
import org.infinispan.lock.configuration.ClusteredLockConfiguration;
import org.infinispan.lock.configuration.Reliability;
import org.infinispan.lock.logging.Log;

public class ClusteredLockManagerConfiguration {
    private static final Log log = (Log)LogFactory.getLog(ClusteredLockManagerConfiguration.class, Log.class);
    static final AttributeDefinition<Reliability> RELIABILITY = AttributeDefinition.builder((Enum)Attribute.RELIABILITY, (Object)((Object)Reliability.CONSISTENT)).validator(value -> {
        if (value == null) {
            throw log.invalidReliabilityMode();
        }
    }).immutable().build();
    static final AttributeDefinition<Integer> NUM_OWNERS = AttributeDefinition.builder((Enum)Attribute.NUM_OWNERS, (Object)-1).validator(value -> {
        if (value <= 0 && value != -1) {
            throw log.invalidNumOwners((Integer)value);
        }
    }).immutable().build();
    private final AttributeSet attributes;
    private Map<String, ClusteredLockConfiguration> locks;

    ClusteredLockManagerConfiguration(AttributeSet attributes, Map<String, ClusteredLockConfiguration> locks) {
        this.attributes = attributes;
        this.locks = locks;
    }

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(ClusteredLockManagerConfiguration.class, new AttributeDefinition[]{NUM_OWNERS, RELIABILITY});
    }

    public int numOwners() {
        return (Integer)this.attributes.attribute(NUM_OWNERS).get();
    }

    public Reliability reliability() {
        return (Reliability)((Object)this.attributes.attribute(RELIABILITY).get());
    }

    AttributeSet attributes() {
        return this.attributes;
    }

    public Map<String, ClusteredLockConfiguration> locks() {
        return this.locks;
    }
}

