/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock;

import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.lock.configuration.ClusteredLockManagerConfiguration;
import org.infinispan.lock.configuration.ClusteredLockManagerConfigurationBuilder;
import org.infinispan.lock.configuration.Reliability;
import org.infinispan.lock.exception.ClusteredLockException;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.partitionhandling.PartitionHandling;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.TransactionMode;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="clusteredLock.ConfigurationTest")
public class ConfigurationTest
extends AbstractCacheTest {
    public void testDefaultConfiguration() {
        TestingUtil.withCacheManager(() -> ConfigurationTest.buildCacheManager(GlobalConfigurationBuilder.defaultClusteredBuilder()), cacheManager -> {
            ClusteredLockManagerConfiguration configuration = ClusteredLockManagerConfigurationBuilder.defaultConfiguration();
            Configuration cacheConfiguration = ConfigurationTest.getClusteredLockCacheConfiguration(cacheManager);
            ConfigurationTest.assertLockAndCacheConfiguration(configuration, cacheConfiguration);
        });
    }

    public void testReliabilityAvailable() {
        GlobalConfigurationBuilder builder = GlobalConfigurationBuilder.defaultClusteredBuilder();
        ClusteredLockManagerConfiguration config = ((ClusteredLockManagerConfigurationBuilder)builder.addModule(ClusteredLockManagerConfigurationBuilder.class)).reliability(Reliability.AVAILABLE).create();
        TestingUtil.withCacheManager(() -> ConfigurationTest.buildCacheManager(builder), cacheManager -> {
            Configuration cacheConfiguration = ConfigurationTest.getClusteredLockCacheConfiguration(cacheManager);
            ConfigurationTest.assertLockAndCacheConfiguration(config, cacheConfiguration);
        });
    }

    public void testReliabilityConsistent() {
        GlobalConfigurationBuilder builder = GlobalConfigurationBuilder.defaultClusteredBuilder();
        ClusteredLockManagerConfiguration config = ((ClusteredLockManagerConfigurationBuilder)builder.addModule(ClusteredLockManagerConfigurationBuilder.class)).reliability(Reliability.CONSISTENT).create();
        TestingUtil.withCacheManager(() -> ConfigurationTest.buildCacheManager(builder), cacheManager -> {
            Configuration cacheConfiguration = ConfigurationTest.getClusteredLockCacheConfiguration(cacheManager);
            ConfigurationTest.assertLockAndCacheConfiguration(config, cacheConfiguration);
        });
    }

    public void testNumOwner() {
        GlobalConfigurationBuilder builder = GlobalConfigurationBuilder.defaultClusteredBuilder();
        ClusteredLockManagerConfiguration config = ((ClusteredLockManagerConfigurationBuilder)builder.addModule(ClusteredLockManagerConfigurationBuilder.class)).numOwner(5).create();
        TestingUtil.withCacheManager(() -> ConfigurationTest.buildCacheManager(builder), cacheManager -> {
            Configuration cacheConfiguration = ConfigurationTest.getClusteredLockCacheConfiguration(cacheManager);
            ConfigurationTest.assertLockAndCacheConfiguration(config, cacheConfiguration);
        });
    }

    public void testMinusOneNumberOfOwner() {
        GlobalConfigurationBuilder builder = GlobalConfigurationBuilder.defaultClusteredBuilder();
        ClusteredLockManagerConfiguration config = ((ClusteredLockManagerConfigurationBuilder)builder.addModule(ClusteredLockManagerConfigurationBuilder.class)).numOwner(-1).create();
        TestingUtil.withCacheManager(() -> ConfigurationTest.buildCacheManager(builder), cacheManager -> {
            Configuration cacheConfiguration = ConfigurationTest.getClusteredLockCacheConfiguration(cacheManager);
            ConfigurationTest.assertLockAndCacheConfiguration(config, cacheConfiguration);
        });
    }

    public void testInvalidReliability() {
        GlobalConfigurationBuilder builder = GlobalConfigurationBuilder.defaultClusteredBuilder();
        ClusteredLockManagerConfigurationBuilder clBuilder = (ClusteredLockManagerConfigurationBuilder)builder.addModule(ClusteredLockManagerConfigurationBuilder.class);
        clBuilder.reliability(null);
        this.assertClusteredLockConfigurationException(builder);
    }

    public void testInvalidNumOwner() {
        GlobalConfigurationBuilder builder = GlobalConfigurationBuilder.defaultClusteredBuilder();
        ClusteredLockManagerConfigurationBuilder clBuilder = (ClusteredLockManagerConfigurationBuilder)builder.addModule(ClusteredLockManagerConfigurationBuilder.class);
        clBuilder.numOwner(0);
        this.assertClusteredLockConfigurationException(builder);
    }

    private static Configuration getClusteredLockCacheConfiguration(EmbeddedCacheManager cacheManager) {
        return cacheManager.getCache("org.infinispan.LOCKS").getCacheConfiguration();
    }

    private static EmbeddedCacheManager buildCacheManager(GlobalConfigurationBuilder builder) {
        return new DefaultCacheManager(builder.build());
    }

    private static void assertLockAndCacheConfiguration(ClusteredLockManagerConfiguration config, Configuration cacheConfig) {
        AssertJUnit.assertEquals((Object)(config.numOwners() < 0 ? CacheMode.REPL_SYNC : CacheMode.DIST_SYNC), (Object)cacheConfig.clustering().cacheMode());
        if (config.numOwners() > 0) {
            AssertJUnit.assertEquals((int)config.numOwners(), (int)cacheConfig.clustering().hash().numOwners());
        }
        AssertJUnit.assertEquals((Object)(config.reliability() == Reliability.CONSISTENT ? PartitionHandling.DENY_READ_WRITES : PartitionHandling.ALLOW_READ_WRITES), (Object)cacheConfig.clustering().partitionHandling().whenSplit());
        AssertJUnit.assertFalse((boolean)cacheConfig.clustering().l1().enabled());
        AssertJUnit.assertEquals((Object)TransactionMode.NON_TRANSACTIONAL, (Object)cacheConfig.transaction().transactionMode());
    }

    private void assertClusteredLockConfigurationException(GlobalConfigurationBuilder builder) {
        try {
            builder.build();
            AssertJUnit.fail((String)"CacheConfigurationExpected");
        }
        catch (CacheConfigurationException | ClusteredLockException expected) {
            log.trace((Object)"Expected", expected);
        }
    }
}

