/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock.impl.functions;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.lock.impl.entries.ClusteredLockKey;
import org.infinispan.lock.impl.entries.ClusteredLockValue;
import org.infinispan.lock.impl.externalizers.ExternalizerIds;
import org.infinispan.lock.impl.log.Log;

public class UnlockFunction
implements Function<EntryView.ReadWriteEntryView<ClusteredLockKey, ClusteredLockValue>, Void> {
    private static final Log log = (Log)LogFactory.getLog(UnlockFunction.class, Log.class);
    public static final AdvancedExternalizer<UnlockFunction> EXTERNALIZER = new Externalizer();
    private final String requestId;
    private final Object requestor;

    public UnlockFunction(Object requestor) {
        this.requestId = null;
        this.requestor = requestor;
    }

    public UnlockFunction(String requestId, Object requestor) {
        this.requestId = requestId;
        this.requestor = requestor;
    }

    @Override
    public Void apply(EntryView.ReadWriteEntryView<ClusteredLockKey, ClusteredLockValue> entryView) {
        boolean ownerMatches;
        ClusteredLockValue lockValue = (ClusteredLockValue)entryView.find().orElseThrow(() -> log.lockDeleted());
        boolean requestIdMatches = this.requestId == null || lockValue.getRequestId() != null && lockValue.getRequestId().equals(this.requestId);
        boolean bl = ownerMatches = lockValue.getOwner() != null && lockValue.getOwner().equals(this.requestor);
        if (requestIdMatches && ownerMatches) {
            entryView.set((Object)ClusteredLockValue.INITIAL_STATE, new MetaParam.Writable[0]);
        }
        return null;
    }

    private static class Externalizer
    implements AdvancedExternalizer<UnlockFunction> {
        private Externalizer() {
        }

        public Set<Class<? extends UnlockFunction>> getTypeClasses() {
            return Collections.singleton(UnlockFunction.class);
        }

        public Integer getId() {
            return ExternalizerIds.UNLOCK_FUNCTION;
        }

        public void writeObject(ObjectOutput output, UnlockFunction object) throws IOException {
            MarshallUtil.marshallString((String)object.requestId, (ObjectOutput)output);
            output.writeObject(object.requestor);
        }

        public UnlockFunction readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new UnlockFunction(MarshallUtil.unmarshallString((ObjectInput)input), input.readObject());
        }
    }
}

