/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock.impl.lock;

import java.util.List;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.Util;
import org.infinispan.filter.KeyFilter;
import org.infinispan.functional.FunctionalMap;
import org.infinispan.functional.impl.FunctionalMapImpl;
import org.infinispan.functional.impl.ReadWriteMapImpl;
import org.infinispan.lock.api.ClusteredLock;
import org.infinispan.lock.exception.ClusteredLockException;
import org.infinispan.lock.impl.entries.ClusteredLockKey;
import org.infinispan.lock.impl.entries.ClusteredLockState;
import org.infinispan.lock.impl.entries.ClusteredLockValue;
import org.infinispan.lock.impl.functions.IsLocked;
import org.infinispan.lock.impl.functions.LockFunction;
import org.infinispan.lock.impl.functions.UnlockFunction;
import org.infinispan.lock.impl.lock.ClusteredLockFilter;
import org.infinispan.lock.impl.log.Log;
import org.infinispan.lock.impl.manager.EmbeddedClusteredLockManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.partitionhandling.AvailabilityException;
import org.infinispan.remoting.RemoteException;

public class ClusteredLockImpl
implements ClusteredLock {
    private static final Log log = (Log)LogFactory.getLog(ClusteredLockImpl.class, Log.class);
    private final String name;
    private final ClusteredLockKey lockKey;
    private final EmbeddedClusteredLockManager clusteredLockManager;
    private final FunctionalMap.ReadWriteMap<ClusteredLockKey, ClusteredLockValue> readWriteMap;
    private final Queue<RequestHolder> pendingRequests;
    private final Object originator;

    public ClusteredLockImpl(String name, ClusteredLockKey lockKey, AdvancedCache<ClusteredLockKey, ClusteredLockValue> clusteredLockCache, EmbeddedClusteredLockManager clusteredLockManager) {
        this.name = name;
        this.lockKey = lockKey;
        this.clusteredLockManager = clusteredLockManager;
        this.pendingRequests = new ConcurrentLinkedQueue<RequestHolder>();
        this.readWriteMap = ReadWriteMapImpl.create((FunctionalMapImpl)FunctionalMapImpl.create(clusteredLockCache));
        this.originator = clusteredLockCache.getCacheManager().getAddress();
        clusteredLockCache.getCacheManager().addListener((Object)new ClusterChangeListener());
        clusteredLockCache.addListener((Object)new LockReleasedListener(), (KeyFilter)new ClusteredLockFilter(lockKey));
    }

    public CompletableFuture<Void> lock() {
        log.tracef("lock called from %s", this.originator);
        CompletableFuture<Void> lockRequest = new CompletableFuture<Void>();
        this.lock(new LockRequestHolder(this.originator, lockRequest));
        return lockRequest;
    }

    private void lock(RequestHolder<Void> requestHolder) {
        if (requestHolder == null || requestHolder.isDone()) {
            return;
        }
        this.pendingRequests.offer(requestHolder);
        this.readWriteMap.eval((Object)this.lockKey, (Function)new LockFunction(requestHolder.requestId, requestHolder.requestor)).whenComplete((lockResult, ex) -> requestHolder.handleLockResult((Boolean)lockResult, (Throwable)ex));
    }

    public CompletableFuture<Boolean> tryLock() {
        log.tracef("tryLock called from %s", this.originator);
        CompletableFuture<Boolean> tryLockRequest = new CompletableFuture<Boolean>();
        this.tryLock(new TryLockRequestHolder(this.originator, tryLockRequest));
        return tryLockRequest;
    }

    public CompletableFuture<Boolean> tryLock(long time, TimeUnit unit) {
        log.tracef("tryLock with timeout (%d, %s) called from %s", time, (Object)unit, this.originator);
        CompletableFuture<Boolean> tryLockRequest = new CompletableFuture<Boolean>();
        this.tryLock(new TryLockRequestHolder(this.originator, tryLockRequest, time, unit));
        return tryLockRequest;
    }

    private void tryLock(TryLockRequestHolder requestHolder) {
        if (requestHolder == null || requestHolder.isDone()) {
            return;
        }
        if (requestHolder.hasTimeout()) {
            this.pendingRequests.offer(requestHolder);
        }
        this.readWriteMap.eval((Object)this.lockKey, (Function)new LockFunction(requestHolder.requestId, requestHolder.requestor)).whenComplete((lockResult, ex) -> requestHolder.handleLockResult((Boolean)lockResult, (Throwable)ex));
    }

    public CompletableFuture<Void> unlock() {
        log.tracef("unlock called from %s", this.originator);
        CompletableFuture<Void> unlockRequest = new CompletableFuture<Void>();
        this.readWriteMap.eval((Object)this.lockKey, (Function)new UnlockFunction(this.originator)).whenComplete((lockResult, ex) -> {
            if (ex == null) {
                unlockRequest.complete(null);
            } else {
                unlockRequest.completeExceptionally(this.handleException((Throwable)ex));
            }
        });
        return unlockRequest;
    }

    public CompletableFuture<Boolean> isLocked() {
        log.tracef("isLocked called from %s", this.originator);
        CompletableFuture<Boolean> isLockedRequest = new CompletableFuture<Boolean>();
        this.readWriteMap.eval((Object)this.lockKey, (Function)new IsLocked()).whenComplete((isLocked, ex) -> {
            if (ex == null) {
                isLockedRequest.complete((Boolean)isLocked);
            } else {
                isLockedRequest.completeExceptionally(this.handleException((Throwable)ex));
            }
        });
        return isLockedRequest;
    }

    public CompletableFuture<Boolean> isLockedByMe() {
        log.tracef("isLockedByMe called from %s", this.originator);
        CompletableFuture<Boolean> isLockedByMeRequest = new CompletableFuture<Boolean>();
        this.readWriteMap.eval((Object)this.lockKey, (Function)new IsLocked(this.originator)).whenComplete((isLockedByMe, ex) -> {
            if (ex == null) {
                isLockedByMeRequest.complete((Boolean)isLockedByMe);
            } else {
                isLockedByMeRequest.completeExceptionally(this.handleException((Throwable)ex));
            }
        });
        return isLockedByMeRequest;
    }

    private CompletableFuture<Void> unlock(String requestId, Object owner) {
        log.tracef("unlock called for requestId %s for possible owner %s", owner);
        CompletableFuture<Void> unlockRequest = new CompletableFuture<Void>();
        this.readWriteMap.eval((Object)this.lockKey, (Function)new UnlockFunction(requestId, owner)).whenComplete((lockResult, ex) -> {
            if (ex == null) {
                unlockRequest.complete(null);
            } else {
                unlockRequest.completeExceptionally(this.handleException((Throwable)ex));
            }
        });
        return unlockRequest;
    }

    private Throwable handleException(Throwable ex) {
        Throwable lockException = ex;
        if (ex instanceof RemoteException) {
            lockException = ex.getCause();
        }
        if (!(lockException instanceof ClusteredLockException)) {
            lockException = new ClusteredLockException(ex);
        }
        return lockException;
    }

    public String getName() {
        return this.name;
    }

    public Object getOriginator() {
        return this.originator;
    }

    @Listener
    class ClusterChangeListener {
        ClusterChangeListener() {
        }

        @ViewChanged
        public void viewChange(ViewChangedEvent event) {
            log.trace("viewChange event has been fired");
            List newMembers = event.getNewMembers();
            List oldMembers = event.getOldMembers();
            if (newMembers.size() > 1 || oldMembers.size() == 2 && newMembers.size() == 1) {
                oldMembers.stream().filter(a -> !newMembers.contains(a)).forEach(notPresent -> {
                    try {
                        if (ClusteredLockImpl.this.clusteredLockManager.isDefined(ClusteredLockImpl.this.name)) {
                            ClusteredLockImpl.this.clusteredLockManager.execute(() -> ClusteredLockImpl.this.unlock(null, notPresent).exceptionally(ex -> {
                                log.error("Unlock failed wrong", (Throwable)ex);
                                return null;
                            }));
                        }
                    }
                    catch (AvailabilityException ex) {
                        log.error("Unable to release due to cluster change", ex);
                    }
                });
            }
        }
    }

    @Listener(clustered=true)
    class LockReleasedListener {
        LockReleasedListener() {
        }

        @CacheEntryModified
        public void entryModified(CacheEntryModifiedEvent event) {
            ClusteredLockValue value = (ClusteredLockValue)event.getValue();
            if (value.getState() == ClusteredLockState.RELEASED) {
                RequestHolder nextRequestor = null;
                while (!ClusteredLockImpl.this.pendingRequests.isEmpty() && (nextRequestor == null || nextRequestor.isDone())) {
                    nextRequestor = (RequestHolder)ClusteredLockImpl.this.pendingRequests.poll();
                }
                RequestHolder requestor = nextRequestor;
                ClusteredLockImpl.this.clusteredLockManager.execute(() -> ClusteredLockImpl.this.lock(requestor));
            }
        }

        @CacheEntryRemoved
        public void entryRemoved(CacheEntryRemovedEvent event) {
            while (!ClusteredLockImpl.this.pendingRequests.isEmpty()) {
                ((RequestHolder)ClusteredLockImpl.this.pendingRequests.poll()).handleLockResult(null, (Throwable)log.lockDeleted());
            }
        }
    }

    public class TryLockRequestHolder
    extends RequestHolder<Boolean> {
        private final long time;
        private final TimeUnit unit;
        private boolean isScheduled;

        public TryLockRequestHolder(Object requestor, CompletableFuture<Boolean> request) {
            super(requestor, request);
            this.time = 0L;
            this.unit = null;
        }

        public TryLockRequestHolder(Object requestor, CompletableFuture<Boolean> request, long time, TimeUnit unit) {
            super(requestor, request);
            this.time = time;
            this.unit = unit;
        }

        @Override
        protected void handle(Boolean result) {
            if (this.time <= 0L) {
                log.tracef("Return the request no for %s", this);
                this.request.complete(result);
            } else if (result.booleanValue()) {
                this.request.complete(true);
                Boolean tryLockRealResult = (Boolean)this.request.join();
                if (!tryLockRealResult.booleanValue()) {
                    ClusteredLockImpl.this.unlock(this.requestId, this.requestor);
                }
            } else if (!this.isScheduled) {
                this.isScheduled = true;
                ClusteredLockImpl.this.clusteredLockManager.schedule(() -> this.request.complete(false), this.time, this.unit);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("TryLockRequestHolder{");
            sb.append(", requestId=").append(this.requestId);
            sb.append(", requestor=").append(this.requestor);
            sb.append(", time=").append(this.time);
            sb.append(", unit=").append((Object)this.unit);
            sb.append(", completed=").append(this.request.isDone());
            sb.append(", completedExceptionally=").append(this.request.isCompletedExceptionally());
            sb.append('}');
            return sb.toString();
        }

        public boolean hasTimeout() {
            return this.time > 0L;
        }
    }

    public class LockRequestHolder
    extends RequestHolder<Void> {
        public LockRequestHolder(Object requestor, CompletableFuture<Void> request) {
            super(requestor, request);
        }

        @Override
        protected void handle(Boolean result) {
            if (result.booleanValue()) {
                this.request.complete(null);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("LockRequestHolder{");
            sb.append(", requestId=").append(this.requestId);
            sb.append(", requestor=").append(this.requestor);
            sb.append(", completed=").append(this.request.isDone());
            sb.append(", completedExceptionally=").append(this.request.isCompletedExceptionally());
            sb.append('}');
            return sb.toString();
        }
    }

    public abstract class RequestHolder<E> {
        protected final CompletableFuture<E> request;
        protected final String requestId = this.createRequestId();
        protected final Object requestor;

        public RequestHolder(Object requestor, CompletableFuture<E> request) {
            this.requestor = requestor;
            this.request = request;
        }

        public boolean isDone() {
            return this.request.isDone();
        }

        public void handleLockResult(Boolean result, Throwable ex) {
            if (ex != null) {
                log.trace("Exception on lock request " + this, ex);
                this.request.completeExceptionally(ClusteredLockImpl.this.handleException(ex));
                return;
            }
            if (result == null) {
                log.trace("Result is null on request " + this);
                this.request.completeExceptionally((Throwable)new ClusteredLockException("Lock result is null, something is wrong"));
                return;
            }
            this.handle(result);
        }

        protected abstract void handle(Boolean var1);

        private String createRequestId() {
            return Util.threadLocalRandomUUID().toString();
        }
    }
}

