/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock.impl.functions;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.lock.impl.entries.ClusteredLockKey;
import org.infinispan.lock.impl.entries.ClusteredLockState;
import org.infinispan.lock.impl.entries.ClusteredLockValue;
import org.infinispan.lock.impl.externalizers.ExternalizerIds;
import org.infinispan.lock.impl.log.Log;

public class LockFunction
implements Function<EntryView.ReadWriteEntryView<ClusteredLockKey, ClusteredLockValue>, Boolean> {
    private static final Log log = (Log)LogFactory.getLog(LockFunction.class, Log.class);
    public static final AdvancedExternalizer<LockFunction> EXTERNALIZER = new Externalizer();
    private final String requestId;
    private final Object requestor;

    public LockFunction(String requestId, Object requestor) {
        this.requestId = requestId;
        this.requestor = requestor;
    }

    @Override
    public Boolean apply(EntryView.ReadWriteEntryView<ClusteredLockKey, ClusteredLockValue> entryView) {
        ClusteredLockValue lock = (ClusteredLockValue)entryView.find().orElseThrow(() -> log.lockDeleted());
        log.tracef("lock request by reqId %s requestor %s", this.requestId, this.requestor);
        if (lock.getState() == ClusteredLockState.RELEASED) {
            entryView.set((Object)new ClusteredLockValue(this.requestId, this.requestor, ClusteredLockState.ACQUIRED), new MetaParam.Writable[0]);
            log.tracef("lock acquired by %s %s", this.requestId, this.requestor);
            return Boolean.TRUE;
        }
        if (lock.getState() == ClusteredLockState.ACQUIRED && lock.getRequestId().equals(this.requestId) && lock.getOwner().equals(this.requestor)) {
            log.tracef("lock already acquired by %s %s", this.requestId, this.requestor);
            return Boolean.TRUE;
        }
        log.tracef("lock not available, owned by %s %s", lock.getRequestId(), lock.getOwner());
        return Boolean.FALSE;
    }

    private static class Externalizer
    implements AdvancedExternalizer<LockFunction> {
        private Externalizer() {
        }

        public Set<Class<? extends LockFunction>> getTypeClasses() {
            return Collections.singleton(LockFunction.class);
        }

        public Integer getId() {
            return ExternalizerIds.LOCK_FUNCTION;
        }

        public void writeObject(ObjectOutput output, LockFunction object) throws IOException {
            MarshallUtil.marshallString((String)object.requestId, (ObjectOutput)output);
            output.writeObject(object.requestor);
        }

        public LockFunction readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new LockFunction(MarshallUtil.unmarshallString((ObjectInput)input), input.readObject());
        }
    }
}

