/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock;

import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.functional.FunctionalTestUtils;
import org.infinispan.lock.EmbeddedClusteredLockManagerFactory;
import org.infinispan.lock.api.ClusteredLock;
import org.infinispan.lock.api.ClusteredLockManager;
import org.infinispan.lock.exception.ClusteredLockException;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.partitionhandling.AvailabilityException;
import org.infinispan.partitionhandling.BasePartitionHandlingTest;
import org.infinispan.test.Exceptions;
import org.infinispan.test.fwk.TransportFlags;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="clusteredLock.ClusteredLockSplitBrainTest")
public class ClusteredLockSplitBrainTest
extends BasePartitionHandlingTest {
    private static final String LOCK_NAME = "ClusteredLockSplitBrainTest";

    public ClusteredLockSplitBrainTest() {
        this.numMembersInCluster = 6;
    }

    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder dcc = this.cacheConfiguration();
        dcc.clustering().cacheMode(this.cacheMode).partitionHandling().whenSplit(this.partitionHandling).mergePolicy(this.mergePolicy);
        if (this.biasAcquisition != null) {
            dcc.clustering().biasAcquisition(this.biasAcquisition);
        }
        this.createClusteredCaches(this.numMembersInCluster, dcc, new TransportFlags().withFD(true).withMerge(true));
        this.waitForClusterToForm("org.infinispan.LOCKS");
    }

    @Test
    public void testLockCreationWhenPartitionHappening() throws Throwable {
        ClusteredLockManager clusteredLockManager = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)((EmbeddedCacheManager)this.getCacheManagers().get(0)));
        FunctionalTestUtils.await((CompletableFuture)clusteredLockManager.remove(LOCK_NAME));
        this.splitCluster(new int[][]{{0, 1, 2}, {3, 4, 5}});
        for (EmbeddedCacheManager cm : this.getCacheManagers()) {
            ClusteredLockManager clm = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)cm);
            this.eventually(() -> this.availabilityExceptionRaised(clm));
        }
    }

    private boolean availabilityExceptionRaised(ClusteredLockManager clm) {
        AvailabilityException ex = null;
        try {
            clm.defineLock(LOCK_NAME);
        }
        catch (AvailabilityException a) {
            ex = a;
        }
        return ex != null;
    }

    @Test
    public void testLockUseAfterPartitionWithoutMajority() throws Throwable {
        ClusteredLockManager clm0 = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)((EmbeddedCacheManager)this.getCacheManagers().get(0)));
        ClusteredLockManager clm1 = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)((EmbeddedCacheManager)this.getCacheManagers().get(1)));
        ClusteredLockManager clm2 = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)((EmbeddedCacheManager)this.getCacheManagers().get(2)));
        ClusteredLockManager clm3 = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)((EmbeddedCacheManager)this.getCacheManagers().get(3)));
        ClusteredLockManager clm4 = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)((EmbeddedCacheManager)this.getCacheManagers().get(4)));
        ClusteredLockManager clm5 = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)((EmbeddedCacheManager)this.getCacheManagers().get(5)));
        clm0.defineLock(LOCK_NAME);
        AssertJUnit.assertTrue((boolean)clm0.isDefined(LOCK_NAME));
        ClusteredLock lock0 = clm0.get(LOCK_NAME);
        ClusteredLock lock1 = clm1.get(LOCK_NAME);
        ClusteredLock lock2 = clm2.get(LOCK_NAME);
        ClusteredLock lock3 = clm3.get(LOCK_NAME);
        ClusteredLock lock4 = clm4.get(LOCK_NAME);
        ClusteredLock lock5 = clm5.get(LOCK_NAME);
        this.splitCluster(new int[][]{{0, 1, 2}, {3, 4, 5}});
        Arrays.asList(lock0, lock1, lock2, lock3, lock4, lock5).forEach(lock -> {
            AssertJUnit.assertNotNull((Object)lock);
            FunctionalTestUtils.await((CompletableFuture)((CompletableFuture)lock.tryLock().whenComplete((r, ex) -> AssertJUnit.fail((String)("should go the exceptionally! r=" + r + "ex= " + ex)))).exceptionally(t -> {
                Exceptions.assertException(CompletionException.class, ClusteredLockException.class, AvailabilityException.class, (Throwable)t);
                return null;
            }));
        });
    }

    @Test
    public void testLockUseAfterPartitionWithMajority() throws Throwable {
        ClusteredLockManager clm0 = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)((EmbeddedCacheManager)this.getCacheManagers().get(0)));
        ClusteredLockManager clm1 = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)((EmbeddedCacheManager)this.getCacheManagers().get(1)));
        ClusteredLockManager clm2 = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)((EmbeddedCacheManager)this.getCacheManagers().get(2)));
        ClusteredLockManager clm3 = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)((EmbeddedCacheManager)this.getCacheManagers().get(3)));
        ClusteredLockManager clm4 = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)((EmbeddedCacheManager)this.getCacheManagers().get(4)));
        ClusteredLockManager clm5 = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)((EmbeddedCacheManager)this.getCacheManagers().get(5)));
        AssertJUnit.assertTrue((boolean)clm0.defineLock(LOCK_NAME));
        AssertJUnit.assertFalse((boolean)clm1.defineLock(LOCK_NAME));
        AssertJUnit.assertFalse((boolean)clm2.defineLock(LOCK_NAME));
        AssertJUnit.assertFalse((boolean)clm3.defineLock(LOCK_NAME));
        AssertJUnit.assertFalse((boolean)clm4.defineLock(LOCK_NAME));
        AssertJUnit.assertFalse((boolean)clm5.defineLock(LOCK_NAME));
        ClusteredLock lock0 = clm0.get(LOCK_NAME);
        ClusteredLock lock1 = clm1.get(LOCK_NAME);
        ClusteredLock lock2 = clm2.get(LOCK_NAME);
        ClusteredLock lock3 = clm3.get(LOCK_NAME);
        ClusteredLock lock4 = clm4.get(LOCK_NAME);
        ClusteredLock lock5 = clm5.get(LOCK_NAME);
        this.splitCluster(new int[][]{{0, 1, 2, 3}, {4, 5}});
        Arrays.asList(lock0, lock1, lock2, lock3).forEach(lock -> this.assertTryLock((ClusteredLock)lock));
        this.assertFailureFromMinorityPartition(lock4);
        this.assertFailureFromMinorityPartition(lock5);
    }

    @Test
    public void testAutoReleaseIfLockIsAcquiredFromAMinorityPartition() throws Throwable {
        ClusteredLockManager clm0 = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)((EmbeddedCacheManager)this.getCacheManagers().get(0)));
        ClusteredLockManager clm1 = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)((EmbeddedCacheManager)this.getCacheManagers().get(1)));
        ClusteredLockManager clm2 = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)((EmbeddedCacheManager)this.getCacheManagers().get(2)));
        AssertJUnit.assertTrue((boolean)clm0.defineLock(LOCK_NAME));
        ClusteredLock lock0 = clm0.get(LOCK_NAME);
        ClusteredLock lock1 = clm1.get(LOCK_NAME);
        ClusteredLock lock2 = clm2.get(LOCK_NAME);
        FunctionalTestUtils.await((CompletableFuture)lock0.tryLock());
        AssertJUnit.assertTrue((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)lock0.isLockedByMe())));
        this.splitCluster(new int[][]{{0}, {1, 2, 3, 4, 5}});
        CompletableFuture tryLock1Result = lock1.tryLock(1L, TimeUnit.SECONDS);
        CompletableFuture tryLock2Result = lock2.tryLock(1L, TimeUnit.SECONDS);
        AssertJUnit.assertTrue((String)"Just one of the locks has to work", (boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)tryLock1Result) ^ (Boolean)FunctionalTestUtils.await((CompletableFuture)tryLock2Result)));
        this.assertFailureFromMinorityPartition(lock0);
    }

    @Test
    public void testTryLocksBeforeSplitBrain() throws Throwable {
        ClusteredLockManager clm0 = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)((EmbeddedCacheManager)this.getCacheManagers().get(0)));
        ClusteredLockManager clm1 = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)((EmbeddedCacheManager)this.getCacheManagers().get(1)));
        ClusteredLockManager clm2 = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)((EmbeddedCacheManager)this.getCacheManagers().get(2)));
        AssertJUnit.assertTrue((boolean)clm0.defineLock(LOCK_NAME));
        ClusteredLock lock0 = clm0.get(LOCK_NAME);
        ClusteredLock lock1 = clm1.get(LOCK_NAME);
        ClusteredLock lock2 = clm2.get(LOCK_NAME);
        CompletableFuture tryLock1 = lock1.tryLock();
        CompletableFuture tryLock2 = lock2.tryLock();
        this.splitCluster(new int[][]{{0}, {1, 2, 3, 4, 5}});
        AssertJUnit.assertTrue((String)"Just one of the locks has to work", (boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)tryLock1) ^ (Boolean)FunctionalTestUtils.await((CompletableFuture)tryLock2)));
        this.assertFailureFromMinorityPartition(lock0);
    }

    private void assertTryLock(ClusteredLock lock) {
        AssertJUnit.assertTrue((String)("Lock acquisition should be true " + lock), (boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)((CompletableFuture)lock.tryLock(29L, TimeUnit.SECONDS).thenApply(tryLockRequest -> {
            if (tryLockRequest.booleanValue()) {
                FunctionalTestUtils.await((CompletableFuture)lock.unlock());
            }
            return tryLockRequest;
        })).exceptionally(ex -> {
            AssertJUnit.fail((String)("Should not be failing from majority partition " + lock + " " + ex.getMessage()));
            return Boolean.FALSE;
        }))));
    }

    private void assertFailureFromMinorityPartition(ClusteredLock lock) {
        FunctionalTestUtils.await((CompletableFuture)((CompletableFuture)lock.tryLock().whenComplete((r, ex) -> AssertJUnit.fail((String)"Should fail from minority partition"))).exceptionally(ex -> {
            Exceptions.assertException(CompletionException.class, ClusteredLockException.class, AvailabilityException.class, (Throwable)ex);
            return null;
        }));
    }
}

