/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.infinispan.functional.FunctionalTestUtils;
import org.infinispan.lock.BaseClusteredLockTest;
import org.infinispan.lock.api.ClusteredLock;
import org.infinispan.lock.api.ClusteredLockConfiguration;
import org.infinispan.lock.api.ClusteredLockManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="clusteredLock.ClusteredLockWith2NodesTest")
public class ClusteredLockWith2NodesTest
extends BaseClusteredLockTest {
    protected static final String LOCK_NAME = "ClusteredLockWith2NodesTest";

    @Override
    protected int clusterSize() {
        return 2;
    }

    @BeforeMethod(alwaysRun=true)
    public void createLock() throws Throwable {
        ClusteredLockManager m1 = this.clusteredLockManager(0);
        m1.defineLock(LOCK_NAME, new ClusteredLockConfiguration());
    }

    @AfterMethod(alwaysRun=true)
    protected void destroyLock() {
        ClusteredLockManager clusteredLockManager = this.clusteredLockManager(1);
        FunctionalTestUtils.await((CompletableFuture)clusteredLockManager.remove(LOCK_NAME));
    }

    @Test
    public void testTryLockAndKillLocking() throws Throwable {
        ClusteredLock firstLockOwner = this.clusteredLockManager(0).get(LOCK_NAME);
        ClusteredLock secondLockOwner = this.clusteredLockManager(1).get(LOCK_NAME);
        StringBuilder value = new StringBuilder();
        FunctionalTestUtils.await((CompletableFuture)firstLockOwner.tryLock().whenComplete((firstTryLockResult, ex1) -> {
            if (ex1 == null) {
                if (firstTryLockResult.booleanValue()) {
                    TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.manager(0)});
                } else {
                    AssertJUnit.fail((String)"Manager 0 could not acquire the lock");
                }
            } else {
                AssertJUnit.fail((String)ex1.getMessage());
            }
            FunctionalTestUtils.await((CompletableFuture)secondLockOwner.tryLock(1L, TimeUnit.SECONDS).whenComplete((secondTryLockResult, ex2) -> {
                if (ex2 == null && secondTryLockResult.booleanValue()) {
                    value.append("hello");
                } else {
                    AssertJUnit.fail((String)ex2.getMessage());
                }
            }));
        }));
        AssertJUnit.assertEquals((String)"hello", (String)value.toString());
    }
}

