/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.lambda;

import java.util.function.BiConsumer;
import java.util.function.Predicate;

public class NamedLambdas {
    public static <T, U> BiConsumer<T, U> of(String description, BiConsumer<T, U> consumer) {
        return new NamedBiConsumer<T, U>(description, consumer);
    }

    public static <T> Predicate<T> of(String description, Predicate<T> predicate) {
        return new NamedPredicate<T>(description, predicate);
    }

    private static class NamedBiConsumer<T, U>
    implements BiConsumer<T, U> {
        private String description;
        private BiConsumer<T, U> biConsumer;

        public NamedBiConsumer(String description, BiConsumer<T, U> biConsumer) {
            this.description = description;
            this.biConsumer = biConsumer;
        }

        @Override
        public void accept(T t, U u) {
            this.biConsumer.accept(t, u);
        }

        @Override
        public BiConsumer<T, U> andThen(BiConsumer<? super T, ? super U> after) {
            return this.biConsumer.andThen(after);
        }

        public String toString() {
            return this.description;
        }
    }

    private static class NamedPredicate<T>
    implements Predicate<T> {
        private String description;
        private Predicate<T> predicate;

        public NamedPredicate(String description, Predicate<T> predicate) {
            this.description = description;
            this.predicate = predicate;
        }

        @Override
        public boolean test(T t) {
            return this.predicate.test(t);
        }

        @Override
        public Predicate<T> and(Predicate<? super T> other) {
            return this.predicate.and(other);
        }

        @Override
        public Predicate<T> negate() {
            return this.predicate.negate();
        }

        @Override
        public Predicate<T> or(Predicate<? super T> other) {
            return this.predicate.or(other);
        }

        public String toString() {
            return this.description;
        }
    }
}

