/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.test;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.stream.XMLStreamException;
import org.infinispan.commons.test.PolarionJUnitXMLWriter;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ISuiteResult;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.annotations.Test;
import org.testng.collections.Maps;
import org.testng.internal.IResultListener2;
import org.testng.internal.Utils;

public class PolarionJUnitXMLReporter
implements IResultListener2,
ISuiteListener {
    private AtomicInteger m_numFailed = new AtomicInteger(0);
    private AtomicInteger m_numSkipped = new AtomicInteger(0);
    private Map<String, List<ITestResult>> m_allTests = Collections.synchronizedMap(new TreeMap());

    public void beforeConfiguration(ITestResult tr) {
    }

    public void onTestStart(ITestResult result) {
    }

    public void onTestSuccess(ITestResult tr) {
        this.checkDuplicatesAndAdd(tr);
    }

    public void onTestFailure(ITestResult tr) {
        this.checkDuplicatesAndAdd(tr);
        this.m_numFailed.incrementAndGet();
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult tr) {
        this.checkDuplicatesAndAdd(tr);
        this.m_numFailed.incrementAndGet();
    }

    public void onTestSkipped(ITestResult tr) {
        this.checkDuplicatesAndAdd(tr);
        this.m_numSkipped.incrementAndGet();
    }

    public void onStart(ITestContext context) {
    }

    public void onFinish(ITestContext context) {
    }

    public void onStart(ISuite suite) {
        this.resetAll();
    }

    public void onFinish(ISuite suite) {
        this.generateReport(suite);
    }

    public void onConfigurationFailure(ITestResult tr) {
        this.checkDuplicatesAndAdd(tr);
        this.m_numFailed.incrementAndGet();
    }

    public void onConfigurationSkip(ITestResult tr) {
    }

    public void onConfigurationSuccess(ITestResult itr) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateReport(ISuite suite) {
        long elapsedTime = 0L;
        long testCount = 0L;
        for (List<ITestResult> testResults : this.m_allTests.values()) {
            for (ITestResult tr : testResults) {
                elapsedTime += tr.getEndMillis() - tr.getStartMillis();
                ++testCount;
            }
        }
        PolarionJUnitXMLWriter writer = null;
        try {
            String outputDir = suite.getOutputDirectory().replaceAll(".Surefire suite", "");
            String baseName = String.format("TEST-%s.xml", this.getSuiteName(suite));
            File outputFile = new File(outputDir, baseName);
            writer = new PolarionJUnitXMLWriter(outputFile);
            writer.start(this.getModuleSuffix(), testCount, this.m_numSkipped.get(), this.m_numFailed.get(), elapsedTime, true);
            this.writeTestResults(writer, this.m_allTests.values());
        }
        catch (Exception e) {
            System.err.println("Error writing test report");
            e.printStackTrace(System.err);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception e) {
                System.err.println("Error writing test report");
                e.printStackTrace(System.err);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTestResults(PolarionJUnitXMLWriter document, Collection<List<ITestResult>> results) throws XMLStreamException {
        Collection<List<ITestResult>> collection = results;
        synchronized (collection) {
            for (List<ITestResult> testResults : results) {
                boolean hasFailures = false;
                for (ITestResult tr : testResults) {
                    if (tr.isSuccess()) continue;
                    hasFailures = true;
                    this.writeTestCase(document, tr);
                }
                if (hasFailures) continue;
                this.writeTestCase(document, testResults.get(0));
            }
        }
    }

    private void writeTestCase(PolarionJUnitXMLWriter writer, ITestResult tr) throws XMLStreamException {
        String className = tr.getTestClass().getRealClass().getName();
        String testName = this.testName(tr);
        long elapsedTimeMillis = tr.getEndMillis() - tr.getStartMillis();
        PolarionJUnitXMLWriter.Status status = this.translateStatus(tr);
        Throwable throwable = tr.getThrowable();
        if (throwable != null) {
            writer.writeTestCase(testName, className, elapsedTimeMillis, status, Utils.shortStackTrace((Throwable)throwable, (boolean)true), throwable.getClass().getName(), throwable.getMessage());
        } else {
            writer.writeTestCase(testName, className, elapsedTimeMillis, status, null, null, null);
        }
    }

    private PolarionJUnitXMLWriter.Status translateStatus(ITestResult tr) {
        switch (tr.getStatus()) {
            case 2: {
                return PolarionJUnitXMLWriter.Status.FAILURE;
            }
            case 1: {
                return PolarionJUnitXMLWriter.Status.SUCCESS;
            }
            case 3: 
            case 4: {
                return PolarionJUnitXMLWriter.Status.SKIPPED;
            }
        }
        return PolarionJUnitXMLWriter.Status.ERROR;
    }

    private void resetAll() {
        this.m_allTests = Collections.synchronizedMap(Maps.newHashMap());
        this.m_numFailed.set(0);
        this.m_numSkipped.set(0);
    }

    private String getSuiteName(ISuite suite) {
        String name = this.getModuleSuffix();
        Collection suiteResults = suite.getResults().values();
        if (suiteResults.size() == 1) {
            ITestNGMethod[] testMethods = ((ISuiteResult)suiteResults.iterator().next()).getTestContext().getAllTestMethods();
            if (testMethods.length > 0) {
                Class testClass = testMethods[0].getConstructorOrMethod().getDeclaringClass();
                String className = testClass.getName();
                String packageName = testClass.getPackage().getName();
                boolean oneTestClass = true;
                boolean oneTestPackage = true;
                for (ITestNGMethod method : testMethods) {
                    if (!method.getConstructorOrMethod().getDeclaringClass().getName().equals(className)) {
                        oneTestClass = false;
                    }
                    if (method.getConstructorOrMethod().getDeclaringClass().getPackage().getName().equals(packageName)) continue;
                    oneTestPackage = false;
                }
                if (oneTestClass) {
                    name = className;
                } else if (oneTestPackage) {
                    name = packageName;
                }
            } else {
                System.err.println("[" + this.getClass().getSimpleName() + "] Test suite '" + name + "' results have no test methods");
            }
        }
        return name;
    }

    private String testName(ITestResult res) {
        StringBuilder result = new StringBuilder(res.getMethod().getMethodName());
        if (res.getMethod().getConstructorOrMethod().getMethod().isAnnotationPresent(Test.class)) {
            String dataProviderName = res.getMethod().getConstructorOrMethod().getMethod().getAnnotation(Test.class).dataProvider();
            if (res.getParameters().length != 0 && dataProviderName != null && !dataProviderName.isEmpty()) {
                result.append("(").append(this.deepToStringParameters(res));
            }
            if (res.getMethod().getConstructorOrMethod().getMethod().getAnnotation(Test.class).invocationCount() > 1) {
                if (result.indexOf("(") == -1) {
                    result.append("(");
                } else {
                    result.append(", ");
                }
                result.append("invoked ").append(res.getMethod().getConstructorOrMethod().getMethod().getAnnotation(Test.class).invocationCount()).append(" times");
            }
            if (this.getModuleSuffix().contains("jcache")) {
                if (result.indexOf("(") == -1) {
                    result.append("(");
                } else {
                    result.append(", ");
                }
                if (this.getModuleSuffix().contains("infinispan-jcache-remote")) {
                    result.append("remote");
                } else {
                    result.append("embedded");
                }
            }
            if (result.indexOf("(") != -1) {
                result.append(")");
            }
        }
        return result.toString();
    }

    private String deepToStringParameters(ITestResult res) {
        Object[] parameters = res.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            Object parameter = parameters[i];
            if (parameter == null) continue;
            if (parameter instanceof Path) {
                parameters[i] = ((Path)parameter).getFileName().toString();
                continue;
            }
            if (!parameter.getClass().getSimpleName().contains("$$Lambda$")) continue;
            res.setStatus(2);
            res.setThrowable((Throwable)new IllegalStateException("Cannot identify which test is running. Use NamedLambdas.of static method"));
        }
        return Arrays.deepToString(parameters);
    }

    private String getModuleSuffix() {
        return System.getProperty("infinispan.module-suffix").substring(1);
    }

    private void checkDuplicatesAndAdd(ITestResult tr) {
        String instanceName = tr.getInstanceName();
        String key = instanceName + "." + this.testName(tr);
        if (this.m_allTests.containsKey(key)) {
            if (tr.getMethod().getCurrentInvocationCount() == 1 && tr.isSuccess()) {
                System.err.println("[" + this.getClass().getSimpleName() + "] Test case '" + key + "' already exists in the results");
                tr.setStatus(2);
                tr.setThrowable((Throwable)new IllegalStateException("Duplicate test: " + key));
            }
            List<ITestResult> itrList = this.m_allTests.get(key);
            itrList.add(tr);
            this.m_allTests.put(key, itrList);
        } else {
            ArrayList<ITestResult> itrList = new ArrayList<ITestResult>();
            itrList.add(tr);
            this.m_allTests.put(key, itrList);
        }
    }
}

