/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.test;

import java.util.Arrays;
import org.infinispan.commons.test.RunningTestsRegistry;
import org.infinispan.commons.test.TestSuiteProgress;
import org.infinispan.commons.test.ThreadLeakChecker;
import org.jboss.logging.Logger;
import org.testng.IConfigurationListener2;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestResult;
import org.testng.annotations.Test;
import org.testng.xml.XmlClass;

public class TestNGTestListener
implements ITestListener,
IConfigurationListener2,
ISuiteListener {
    private static final Logger log = Logger.getLogger(TestNGTestListener.class);
    private final TestSuiteProgress progressLogger = new TestSuiteProgress();

    public void onTestStart(ITestResult result) {
        this.progressLogger.testStarted(this.testName(result));
    }

    public void onTestSuccess(ITestResult result) {
        this.progressLogger.testSucceeded(this.testName(result));
    }

    public void onTestFailure(ITestResult result) {
        this.progressLogger.testFailed(this.testName(result), result.getThrowable());
    }

    public void onTestSkipped(ITestResult result) {
        RunningTestsRegistry.unregisterThreadWithTest();
        this.progressLogger.testIgnored(this.testName(result));
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult result) {
        this.progressLogger.testFailed(this.testName(result), result.getThrowable());
    }

    public void onStart(ITestContext context) {
        Thread.currentThread().setName("testng-" + context.getName());
        ThreadLeakChecker.testStarted(((XmlClass)context.getCurrentXmlTest().getXmlClasses().get(0)).getName());
    }

    public void onFinish(ITestContext context) {
        String testName = ((XmlClass)context.getCurrentXmlTest().getXmlClasses().get(0)).getName();
        ThreadLeakChecker.testFinished(testName);
    }

    private String testName(ITestResult res) {
        StringBuilder result = new StringBuilder();
        if (res.getInstanceName().contains(res.getMethod().getMethodName())) {
            result.append(res.getTestClass().getName());
        } else {
            result.append(res.getInstanceName());
        }
        result.append(".").append(res.getMethod().getMethodName());
        if (res.getMethod().getConstructorOrMethod().getMethod().isAnnotationPresent(Test.class)) {
            String dataProviderName = res.getMethod().getConstructorOrMethod().getMethod().getAnnotation(Test.class).dataProvider();
            if (res.getParameters().length != 0 && !dataProviderName.isEmpty()) {
                result.append("(").append(Arrays.deepToString(res.getParameters())).append(")");
            }
        }
        return result.toString();
    }

    public void onStart(ISuite suite) {
        ThreadLeakChecker.saveInitialThreads();
    }

    public void onFinish(ISuite suite) {
        ThreadLeakChecker.checkForLeaks(suite.getName());
    }

    public void beforeConfiguration(ITestResult testResult) {
        this.progressLogger.configurationStarted(this.testName(testResult));
        String simpleName = testResult.getTestClass().getRealClass().getSimpleName();
        RunningTestsRegistry.registerThreadWithTest(this.testName(testResult), simpleName);
    }

    public void onConfigurationSuccess(ITestResult testResult) {
        RunningTestsRegistry.unregisterThreadWithTest();
        this.progressLogger.configurationFinished(this.testName(testResult));
    }

    public void onConfigurationFailure(ITestResult testResult) {
        RunningTestsRegistry.unregisterThreadWithTest();
        if (testResult.getThrowable() != null) {
            this.progressLogger.configurationFailed(this.testName(testResult), testResult.getThrowable());
        }
    }

    public void onConfigurationSkip(ITestResult testResult) {
        RunningTestsRegistry.unregisterThreadWithTest();
        if (testResult.getThrowable() != null) {
            this.progressLogger.testIgnored(this.testName(testResult));
        }
    }
}

