/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.test;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Consumer;

public class CommonsTestingUtil {
    public static final String TEST_PATH = "infinispanTempFiles";

    public static String tmpDirectory(Class<?> test) {
        return CommonsTestingUtil.tmpDirectory() + File.separator + TEST_PATH + File.separator + test.getSimpleName();
    }

    public static String tmpDirectory(String folder) {
        return CommonsTestingUtil.tmpDirectory() + File.separator + TEST_PATH + File.separator + folder;
    }

    public static String tmpDirectory() {
        return System.getProperty("infinispan.test.tmpdir", System.getProperty("java.io.tmpdir"));
    }

    public static String javaTmpDirectory(Class<?> test) {
        return System.getProperty("java.io.tmpdir") + File.separator + TEST_PATH + File.separator + test.getSimpleName();
    }

    public static String loadFileAsString(InputStream is) throws IOException {
        StringBuilder sb = new StringBuilder();
        BufferedReader r = new BufferedReader(new InputStreamReader(is));
        String line = r.readLine();
        while (line != null) {
            sb.append(line);
            sb.append("\n");
            line = r.readLine();
        }
        return sb.toString();
    }

    public static class CopyFileVisitor
    extends SimpleFileVisitor<Path> {
        private final Path targetPath;
        private Path sourcePath = null;
        private final CopyOption[] copyOptions;
        private final Consumer<File> manipulator;

        public CopyFileVisitor(Path targetPath, boolean overwrite) {
            this(targetPath, overwrite, null);
        }

        public CopyFileVisitor(Path targetPath, boolean overwrite, Consumer<File> manipulator) {
            CopyOption[] copyOptionArray;
            this.targetPath = targetPath;
            this.manipulator = manipulator;
            if (overwrite) {
                CopyOption[] copyOptionArray2 = new CopyOption[2];
                copyOptionArray2[0] = StandardCopyOption.REPLACE_EXISTING;
                copyOptionArray = copyOptionArray2;
                copyOptionArray2[1] = StandardCopyOption.COPY_ATTRIBUTES;
            } else {
                copyOptionArray = new CopyOption[]{};
            }
            this.copyOptions = copyOptionArray;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            if (this.sourcePath == null) {
                this.sourcePath = dir;
            } else {
                Files.createDirectories(this.targetPath.resolve(this.sourcePath.relativize(dir).toString()), new FileAttribute[0]);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Path target = this.targetPath.resolve(this.sourcePath.relativize(file).toString());
            Files.copy(file, target, this.copyOptions);
            if (this.manipulator != null) {
                this.manipulator.accept(target.toFile());
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

