/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.test;

import java.io.PrintStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.logging.Logger;

public class TestSuiteProgress {
    private static final Logger log = Logger.getLogger(TestSuiteProgress.class);
    private static final String RED = "\u001b[31m";
    private static final String GREEN = "\u001b[32m";
    private static final String YELLOW = "\u001b[33m";
    private static final String RESET = "\u001b[0m";
    private AtomicInteger failed = new AtomicInteger(0);
    private AtomicInteger succeeded = new AtomicInteger(0);
    private AtomicInteger skipped = new AtomicInteger(0);
    private final PrintStream out;
    private final boolean useColor = !Boolean.getBoolean("ansi.strip");

    public TestSuiteProgress() {
        this.out = System.out;
    }

    void testStarted(String name) {
        String message = "Test starting: " + name;
        this.progress(message);
        log.info((Object)message);
    }

    void testSucceeded(String name) {
        this.succeeded.incrementAndGet();
        String message = "Test succeeded: " + name;
        this.progress(GREEN, message);
        log.info((Object)message);
    }

    void testFailed(String name, Throwable exception) {
        this.failed.incrementAndGet();
        String message = "Test failed: " + name;
        this.progress(RED, message, exception);
        log.error((Object)message, exception);
    }

    void testIgnored(String name) {
        this.skipped.incrementAndGet();
        String message = "Test ignored: " + name;
        this.progress(YELLOW, message);
        log.info((Object)message);
    }

    void testAssumptionFailed(String name, Throwable exception) {
        this.skipped.incrementAndGet();
        String message = "Test assumption failed: " + name;
        this.progress(YELLOW, message, exception);
        log.info((Object)message, exception);
    }

    void configurationStarted(String name) {
        log.debug((Object)("Test configuration started: " + name));
    }

    void configurationFinished(String name) {
        log.debug((Object)("Test configuration finished: " + name));
    }

    void configurationFailed(String name, Throwable exception) {
        this.failed.incrementAndGet();
        String message = "Test configuration failed: " + name;
        this.progress(RED, message, exception);
        log.error((Object)message, exception);
    }

    public static void fakeTestFailure(String name, Throwable exception) {
        String message = "Test failed: " + name;
        System.out.printf("[TestSuiteProgress] %s%n", message);
        log.error((Object)message, exception);
    }

    private void progress(CharSequence message) {
        this.progress(null, message, null);
    }

    private void progress(String color, CharSequence message) {
        this.progress(color, message, null);
    }

    private synchronized void progress(String color, CharSequence message, Throwable t) {
        String actualColor = "";
        String actualReset = "";
        if (this.useColor && color != null) {
            actualColor = color;
            actualReset = RESET;
        }
        this.out.printf("%s[OK: %5s, KO: %5s, SKIP: %5s] %s%s%n", actualColor, this.succeeded.get(), this.failed.get(), this.skipped.get(), message, actualReset);
        if (t != null) {
            t.printStackTrace(this.out);
        }
    }
}

