/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.test.skip;

import java.util.Arrays;
import org.infinispan.commons.test.skip.SkipOnOs;
import org.infinispan.commons.test.skip.SkipOnOsUtils;
import org.junit.Assume;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public class SkipOnOsRule
implements MethodRule {
    public Statement apply(Statement base, FrameworkMethod method, Object target) {
        Statement result = base;
        SkipOnOs skipOsAnnotation = this.getSkipOsAnnotation(method);
        if (skipOsAnnotation != null && Arrays.asList(skipOsAnnotation.value()).contains((Object)SkipOnOsUtils.getOs())) {
            result = new IgnoreStatement(method, skipOsAnnotation.value());
        }
        return result;
    }

    private SkipOnOs getSkipOsAnnotation(FrameworkMethod method) {
        return (SkipOnOs)method.getAnnotation(SkipOnOs.class);
    }

    private static class IgnoreStatement
    extends Statement {
        private final FrameworkMethod method;
        private final SkipOnOs.OS[] skippedOses;

        IgnoreStatement(FrameworkMethod method, SkipOnOs.OS[] skippedOses) {
            this.method = method;
            this.skippedOses = skippedOses;
        }

        public void evaluate() {
            String msg = "Skipping test " + this.method.getName() + " on " + Arrays.toString((Object[])this.skippedOses);
            System.out.println(msg);
            Assume.assumeTrue((String)msg, (boolean)false);
        }
    }
}

