/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.test;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.infinispan.commons.test.TestSuiteProgress;
import org.jboss.logging.Logger;
import org.testng.IConfigurationListener2;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestResult;
import org.testng.annotations.Test;

public class TestNGTestListener
implements ITestListener,
IConfigurationListener2,
ISuiteListener {
    private static final Logger log = Logger.getLogger(TestNGTestListener.class);
    private final TestSuiteProgress progressLogger = new TestSuiteProgress();
    private Set<Long> startupThreads;
    private boolean suiteRunning;

    public void onTestStart(ITestResult result) {
        this.progressLogger.testStarted(this.testName(result));
    }

    public void onTestSuccess(ITestResult result) {
        this.progressLogger.testFinished(this.testName(result));
    }

    public void onTestFailure(ITestResult result) {
        this.progressLogger.testFailed(this.testName(result), result.getThrowable());
    }

    public void onTestSkipped(ITestResult result) {
        this.progressLogger.testIgnored(this.testName(result));
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult result) {
        this.progressLogger.testFailed(this.testName(result), result.getThrowable());
    }

    public void onStart(ITestContext context) {
    }

    public void onFinish(ITestContext context) {
    }

    private String testName(ITestResult res) {
        StringBuilder result = new StringBuilder();
        result.append(res.getTestClass().getRealClass().getName()).append(".").append(res.getMethod().getMethodName());
        if (res.getMethod().getConstructorOrMethod().getMethod().isAnnotationPresent(Test.class)) {
            String dataProviderName = res.getMethod().getConstructorOrMethod().getMethod().getAnnotation(Test.class).dataProvider();
            if (res.getParameters().length != 0 && dataProviderName != null && !dataProviderName.isEmpty()) {
                result.append("(").append(Arrays.deepToString(res.getParameters())).append(")");
            }
        }
        return result.toString();
    }

    public void onStart(ISuite isuite) {
        HashSet<Long> threads = new HashSet<Long>();
        for (Map.Entry<Thread, StackTraceElement[]> s : Thread.getAllStackTraces().entrySet()) {
            Thread thread = s.getKey();
            if (thread.getName().startsWith("TestNG")) continue;
            threads.add(thread.getId());
        }
        this.startupThreads = threads;
        this.suiteRunning = true;
    }

    public void onFinish(ISuite isuite) {
        boolean firstTime = this.suiteRunning;
        this.suiteRunning = false;
        if (!firstTime) {
            return;
        }
        int count = 0;
        for (Map.Entry<Thread, StackTraceElement[]> s : Thread.getAllStackTraces().entrySet()) {
            Thread thread = s.getKey();
            if (this.ignoreThread(thread)) continue;
            if (count == 0) {
                log.warn((Object)"Possible leaked threads at the end of the test suite:");
            }
            log.warnf("\"%s\" #%d %sprio=%d tid=0x%x nid=NA %s", new Object[]{thread.getName(), ++count, thread.isDaemon() ? "daemon " : "", thread.getPriority(), thread.getId(), thread.getState().toString().toLowerCase()});
            log.warnf("   java.lang.Thread.State: %s", (Object)thread.getState());
            for (StackTraceElement ste : s.getValue()) {
                log.warnf("\t%s", (Object)ste);
            }
        }
    }

    private boolean ignoreThread(Thread thread) {
        String threadName = thread.getName();
        return threadName.startsWith("testng-") || threadName.startsWith("ForkJoinPool.commonPool-worker-") || this.startupThreads.contains(thread.getId());
    }

    public void beforeConfiguration(ITestResult testResult) {
        log.debugf("Before setup %s", (Object)testResult.getMethod().getMethodName());
    }

    public void onConfigurationSuccess(ITestResult testResult) {
        log.debugf("After setup %s", (Object)testResult.getMethod().getMethodName());
    }

    public void onConfigurationFailure(ITestResult testResult) {
        if (testResult.getThrowable() != null) {
            this.progressLogger.setupFailed(this.testName(testResult), testResult.getThrowable());
        }
    }

    public void onConfigurationSkip(ITestResult testResult) {
        if (testResult.getThrowable() != null) {
            this.progressLogger.testIgnored(this.testName(testResult));
        }
    }
}

