/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ISuiteResult;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.annotations.Test;
import org.testng.collections.Maps;
import org.testng.internal.IResultListener2;
import org.testng.internal.Utils;
import org.testng.reporters.XMLStringBuffer;

public class PolarionJUnitXMLReporter
implements IResultListener2,
ISuiteListener {
    private static final Pattern ENTITY = Pattern.compile("&[a-zA-Z]+;.*");
    private static final Pattern LESS = Pattern.compile("<");
    private static final Pattern GREATER = Pattern.compile(">");
    private static final Pattern SINGLE_QUOTE = Pattern.compile("'");
    private static final Pattern QUOTE = Pattern.compile("\"");
    private static final Map<String, Pattern> ATTR_ESCAPES = Maps.newHashMap();
    private AtomicInteger m_numFailed = new AtomicInteger(0);
    private AtomicInteger m_numSkipped = new AtomicInteger(0);
    private Map<String, List<ITestResult>> m_allTests = Collections.synchronizedMap(Maps.newHashMap());

    public void beforeConfiguration(ITestResult tr) {
    }

    public void onTestStart(ITestResult result) {
    }

    public void onTestSuccess(ITestResult tr) {
        this.checkDuplicatesAndAdd(tr);
    }

    public void onTestFailure(ITestResult tr) {
        this.checkDuplicatesAndAdd(tr);
        this.m_numFailed.incrementAndGet();
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult tr) {
        this.checkDuplicatesAndAdd(tr);
        this.m_numFailed.incrementAndGet();
    }

    public void onTestSkipped(ITestResult tr) {
        this.checkDuplicatesAndAdd(tr);
        this.m_numSkipped.incrementAndGet();
    }

    public void onStart(ITestContext context) {
    }

    public void onFinish(ITestContext context) {
    }

    public void onStart(ISuite suite) {
        this.resetAll();
    }

    public void onFinish(ISuite suite) {
        this.generateReport(suite);
    }

    public void onConfigurationFailure(ITestResult tr) {
        this.checkDuplicatesAndAdd(tr);
        this.m_numFailed.incrementAndGet();
    }

    public void onConfigurationSkip(ITestResult tr) {
    }

    public void onConfigurationSuccess(ITestResult itr) {
    }

    protected void generateReport(ISuite suite) {
        XMLStringBuffer document = new XMLStringBuffer();
        document.addComment("Generated by " + this.getClass().getName());
        long elapsedTime = 0L;
        long testCount = 0L;
        for (List<ITestResult> testResults : this.m_allTests.values()) {
            for (ITestResult tr : testResults) {
                elapsedTime += tr.getEndMillis() - tr.getStartMillis();
                ++testCount;
            }
        }
        Properties attrs = new Properties();
        attrs.setProperty("tests", "" + testCount);
        attrs.setProperty("time", "" + (double)elapsedTime / 1000.0);
        attrs.setProperty("name", this.getModuleSuffix());
        attrs.setProperty("skipped", "" + this.m_numSkipped);
        attrs.setProperty("errors", "0");
        attrs.setProperty("failures", "" + this.m_numFailed.get());
        document.push("testsuite", attrs);
        this.showProperties(document);
        document.addComment("Tests results");
        this.createElementFromTestResults(document, this.m_allTests.values());
        document.pop();
        Utils.writeUtf8File((String)suite.getOutputDirectory().replaceAll(".Surefire suite", ""), (String)(this.generateFileName(suite) + ".xml"), (String)document.toXML());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createElementFromTestResults(XMLStringBuffer document, Collection<List<ITestResult>> results) {
        Collection<List<ITestResult>> collection = results;
        synchronized (collection) {
            for (List<ITestResult> testResults : results) {
                if (testResults.size() == 1) {
                    this.createElement(document, testResults.get(0));
                    continue;
                }
                boolean hasFailures = false;
                for (ITestResult tr : testResults) {
                    if (tr.isSuccess()) continue;
                    hasFailures = true;
                    this.createElement(document, tr);
                }
                if (hasFailures) continue;
                this.createElement(document, testResults.get(0));
            }
        }
    }

    private void createElement(XMLStringBuffer doc, ITestResult tr) {
        Properties attrs = new Properties();
        long elapsedTimeMillis = tr.getEndMillis() - tr.getStartMillis();
        attrs.setProperty("name", this.testName(tr));
        attrs.setProperty("classname", tr.getTestClass().getRealClass().getName());
        attrs.setProperty("time", "" + (double)elapsedTimeMillis / 1000.0);
        if (2 == tr.getStatus() || 3 == tr.getStatus()) {
            doc.push("testcase", attrs);
            if (2 == tr.getStatus()) {
                this.createFailureElement(doc, tr);
            } else if (3 == tr.getStatus()) {
                this.createSkipElement(doc, tr);
            }
            doc.pop();
        } else {
            doc.addEmptyElement("testcase", attrs);
        }
    }

    private void createFailureElement(XMLStringBuffer doc, ITestResult tr) {
        Properties attrs = new Properties();
        Throwable t = tr.getThrowable();
        if (t != null) {
            attrs.setProperty("type", t.getClass().getName());
            String message = t.getMessage();
            if (message != null && message.length() > 0) {
                attrs.setProperty("message", this.encodeAttr(message));
            }
            doc.push("failure", attrs);
            doc.addCDATA(Utils.stackTrace((Throwable)t, (boolean)false)[0]);
            doc.pop();
        } else {
            doc.addEmptyElement("failure");
        }
    }

    private void createSkipElement(XMLStringBuffer doc, ITestResult tr) {
        doc.addEmptyElement("skipped");
    }

    private String encodeAttr(String attr) {
        String result = this.replaceAmpersand(attr, ENTITY);
        for (Map.Entry<String, Pattern> e : ATTR_ESCAPES.entrySet()) {
            result = e.getValue().matcher(result).replaceAll(e.getKey());
        }
        return result;
    }

    private String replaceAmpersand(String str, Pattern pattern) {
        int start = 0;
        int idx = str.indexOf(38, start);
        if (idx == -1) {
            return str;
        }
        StringBuilder result = new StringBuilder();
        while (idx != -1) {
            result.append(str.substring(start, idx));
            if (pattern.matcher(str.substring(idx)).matches()) {
                result.append("&");
            } else {
                result.append("&amp;");
            }
            start = idx + 1;
            idx = str.indexOf(38, start);
        }
        result.append(str.substring(start));
        return result.toString();
    }

    private void resetAll() {
        this.m_allTests = Collections.synchronizedMap(Maps.newHashMap());
        this.m_numFailed.set(0);
        this.m_numSkipped.set(0);
    }

    private String generateFileName(ISuite suite) {
        String name = this.getModuleSuffix();
        Collection suiteResults = suite.getResults().values();
        if (suiteResults.size() == 1) {
            ITestNGMethod[] testMethods = ((ISuiteResult)suiteResults.iterator().next()).getTestContext().getAllTestMethods();
            if (testMethods.length > 0) {
                Class testClass = testMethods[0].getConstructorOrMethod().getDeclaringClass();
                String className = testClass.getName();
                String packageName = testClass.getPackage().getName();
                boolean oneTestClass = true;
                boolean oneTestPackage = true;
                for (ITestNGMethod method : testMethods) {
                    if (!method.getConstructorOrMethod().getDeclaringClass().getName().equals(className)) {
                        oneTestClass = false;
                    }
                    if (method.getConstructorOrMethod().getDeclaringClass().getPackage().getName().equals(packageName)) continue;
                    oneTestPackage = false;
                }
                if (oneTestClass) {
                    name = className;
                } else if (oneTestPackage) {
                    name = packageName;
                }
            } else {
                System.err.println("[" + this.getClass().getSimpleName() + "] Test suite '" + name + "' results have no test methods");
            }
        }
        return String.format("TEST-%s", name);
    }

    private String testName(ITestResult res) {
        StringBuilder result = new StringBuilder(res.getMethod().getMethodName());
        if (res.getMethod().getConstructorOrMethod().getMethod().isAnnotationPresent(Test.class)) {
            String dataProviderName = res.getMethod().getConstructorOrMethod().getMethod().getAnnotation(Test.class).dataProvider();
            if (res.getParameters().length != 0 && dataProviderName != null && !dataProviderName.isEmpty()) {
                result.append("(").append(Arrays.deepToString(res.getParameters()));
            }
            if (res.getMethod().getConstructorOrMethod().getMethod().getAnnotation(Test.class).invocationCount() > 1) {
                if (result.indexOf("(") == -1) {
                    result.append("(");
                } else {
                    result.append(", ");
                }
                result.append("invoked ").append(res.getMethod().getConstructorOrMethod().getMethod().getAnnotation(Test.class).invocationCount()).append(" times");
            }
            if (this.getModuleSuffix().contains("jcache")) {
                if (result.indexOf("(") == -1) {
                    result.append("(");
                } else {
                    result.append(", ");
                }
                if (this.getModuleSuffix().contains("infinispan-jcache-remote")) {
                    result.append("remote");
                } else {
                    result.append("embedded");
                }
            }
            if (result.indexOf("(") != -1) {
                result.append(")");
            }
        }
        return result.toString();
    }

    private void showProperties(XMLStringBuffer report) {
        Properties property;
        report.push("properties");
        report.addComment("Java System properties");
        for (Object object : System.getProperties().keySet()) {
            property = new Properties();
            property.setProperty("name", object.toString());
            property.setProperty("value", System.getProperty(object.toString()));
            report.addEmptyElement("property", property);
        }
        report.addComment("Environment variables");
        for (String string : System.getenv().keySet()) {
            property = new Properties();
            property.setProperty("name", string.toString());
            property.setProperty("value", System.getenv(string.toString()));
            report.addEmptyElement("property", property);
        }
        report.pop();
    }

    private String getModuleSuffix() {
        return System.getProperty("infinispan.module-suffix").substring(1);
    }

    private void checkDuplicatesAndAdd(ITestResult tr) {
        String instanceName = tr.getInstanceName();
        String key = instanceName + "." + this.testName(tr);
        if (this.m_allTests.containsKey(key)) {
            if (tr.getMethod().getCurrentInvocationCount() == 1) {
                System.err.println("[" + this.getClass().getSimpleName() + "] Test case '" + key + "' already exists in the results");
                tr.setStatus(2);
                tr.setThrowable((Throwable)new IllegalStateException("Duplicate test: " + key));
            }
            List<ITestResult> itrList = this.m_allTests.get(key);
            itrList.add(tr);
            this.m_allTests.put(key, itrList);
        } else {
            ArrayList<ITestResult> itrList = new ArrayList<ITestResult>();
            itrList.add(tr);
            this.m_allTests.put(key, itrList);
        }
    }

    static {
        ATTR_ESCAPES.put("&lt;", LESS);
        ATTR_ESCAPES.put("&gt;", GREATER);
        ATTR_ESCAPES.put("&apos;", SINGLE_QUOTE);
        ATTR_ESCAPES.put("&quot;", QUOTE);
    }
}

