/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.infinispan.commons.test.RunningTestsRegistry;
import org.infinispan.commons.test.TestSuiteProgress;
import org.jboss.logging.Logger;
import org.testng.IConfigurationListener2;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.TestNGException;
import org.testng.annotations.Test;
import org.testng.xml.XmlClass;

public class TestNGTestListener
implements ITestListener,
IConfigurationListener2,
ISuiteListener {
    private static final Set<String> REQUIRED_GROUPS = new HashSet<String>(Arrays.asList("unit", "functional", "xsite", "arquillian", "stress", "profiling", "manual", "unstable"));
    private static final Set<String> ALLOWED_GROUPS = new HashSet<String>(Arrays.asList("unit", "functional", "xsite", "arquillian", "stress", "profiling", "manual", "unstable", "smoke", "java10", "transaction"));
    private static final Logger log = Logger.getLogger(TestNGTestListener.class);
    private final TestSuiteProgress progressLogger = new TestSuiteProgress();
    private Set<Long> startupThreads;
    private boolean suiteRunning;

    public void onTestStart(ITestResult result) {
        this.progressLogger.testStarted(this.testName(result));
    }

    public void onTestSuccess(ITestResult result) {
        this.progressLogger.testSucceeded(this.testName(result));
    }

    public void onTestFailure(ITestResult result) {
        this.progressLogger.testFailed(this.testName(result), result.getThrowable());
    }

    public void onTestSkipped(ITestResult result) {
        this.progressLogger.testIgnored(this.testName(result));
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult result) {
        this.progressLogger.testFailed(this.testName(result), result.getThrowable());
    }

    public void onStart(ITestContext context) {
        Thread.currentThread().setName("testng-" + context.getName());
    }

    public void onFinish(ITestContext context) {
    }

    private String testName(ITestResult res) {
        StringBuilder result = new StringBuilder();
        result.append(res.getInstanceName()).append(".").append(res.getMethod().getMethodName());
        if (res.getMethod().getConstructorOrMethod().getMethod().isAnnotationPresent(Test.class)) {
            String dataProviderName = res.getMethod().getConstructorOrMethod().getMethod().getAnnotation(Test.class).dataProvider();
            if (res.getParameters().length != 0 && !dataProviderName.isEmpty()) {
                result.append("(").append(Arrays.deepToString(res.getParameters())).append(")");
            }
        }
        return result.toString();
    }

    public void onStart(ISuite suite) {
        ArrayList<String> errors = new ArrayList<String>();
        HashSet<Class> classes = new HashSet<Class>();
        this.checkAnnotations(errors, classes, suite.getExcludedMethods());
        this.checkAnnotations(errors, classes, suite.getAllMethods());
        if (!errors.isEmpty()) {
            throw new TestNGException(String.join((CharSequence)"\n", errors));
        }
        this.saveInitialThreads();
        this.suiteRunning = true;
    }

    public void onFinish(ISuite suite) {
        boolean firstTime = this.suiteRunning;
        this.suiteRunning = false;
        if (!firstTime) {
            return;
        }
        this.logLeakedThreads();
    }

    private void saveInitialThreads() {
        HashSet<Long> threads = new HashSet<Long>();
        for (Map.Entry<Thread, StackTraceElement[]> s : Thread.getAllStackTraces().entrySet()) {
            Thread thread = s.getKey();
            if (thread.getName().startsWith("TestNG")) continue;
            threads.add(thread.getId());
        }
        this.startupThreads = threads;
    }

    private void logLeakedThreads() {
        int count = 0;
        for (Map.Entry<Thread, StackTraceElement[]> s : Thread.getAllStackTraces().entrySet()) {
            Thread thread = s.getKey();
            if (this.ignoreThread(thread)) continue;
            if (count == 0) {
                log.warn((Object)"Possible leaked threads at the end of the test suite:");
            }
            log.warnf("\"%s\" #%d %sprio=%d tid=0x%x nid=NA %s", new Object[]{thread.getName(), ++count, thread.isDaemon() ? "daemon " : "", thread.getPriority(), thread.getId(), thread.getState().toString().toLowerCase()});
            log.warnf("   java.lang.Thread.State: %s", (Object)thread.getState());
            for (StackTraceElement ste : s.getValue()) {
                log.warnf("\t%s", (Object)ste);
            }
        }
    }

    private void checkAnnotations(List<String> errors, Set<Class> classes, Collection<ITestNGMethod> methods) {
        for (ITestNGMethod m : methods) {
            this.checkMethodAnnotations(errors, m);
            this.checkClassAnnotations(errors, classes, m);
        }
    }

    private void checkMethodAnnotations(List<String> errors, ITestNGMethod m) {
        if (!m.getEnabled()) {
            return;
        }
        boolean hasRequiredGroup = false;
        for (String g : m.getGroups()) {
            if (!ALLOWED_GROUPS.contains(g)) {
                errors.add("Method " + m.getConstructorOrMethod() + " and/or its class has a @Test annotation with the wrong group: " + g + ".\nAllowed groups are " + ALLOWED_GROUPS);
                return;
            }
            if (!REQUIRED_GROUPS.contains(g)) continue;
            hasRequiredGroup = true;
        }
        if (!hasRequiredGroup) {
            errors.add("Method " + m.getConstructorOrMethod() + " and/or its class don't have any required group.\nRequired groups are " + REQUIRED_GROUPS);
            return;
        }
        Class testClass = m.getRealClass();
        Class declaringClass = m.getConstructorOrMethod().getDeclaringClass();
        Test annotation = testClass.getAnnotation(Test.class);
        if (testClass != declaringClass && !Arrays.equals(annotation.groups(), m.getGroups())) {
            errors.add("Method " + m.getConstructorOrMethod() + " was inherited from class " + declaringClass + " with groups " + Arrays.toString(m.getGroups()) + ", but the test class has groups " + Arrays.toString(annotation.groups()));
        }
    }

    private void checkClassAnnotations(List<String> errors, Set<Class> processedClasses, ITestNGMethod m) {
        Class xmlClass;
        Class testClass = m.getTestClass().getRealClass();
        if (m.getXmlTest().getXmlClasses().size() == 1 && (xmlClass = ((XmlClass)m.getXmlTest().getXmlClasses().get(0)).getSupportClass()) != testClass && processedClasses.add(xmlClass)) {
            errors.add("Class " + xmlClass.getName() + " must override the @Factory method from base class " + testClass.getName());
            return;
        }
        if (!processedClasses.add(testClass)) {
            return;
        }
        Test annotation = testClass.getAnnotation(Test.class);
        if (annotation == null || annotation.testName().isEmpty()) {
            errors.add("Class " + testClass.getName() + " does not have a testName");
            return;
        }
        if (!annotation.testName().contains(testClass.getSimpleName())) {
            errors.add("Class " + testClass.getName() + " has an invalid testName: " + annotation.testName());
        }
    }

    private boolean ignoreThread(Thread thread) {
        String threadName = thread.getName();
        return threadName.startsWith("testng-") || threadName.startsWith("ForkJoinPool.commonPool-worker-") || this.startupThreads.contains(thread.getId());
    }

    public void beforeConfiguration(ITestResult testResult) {
        this.progressLogger.configurationStarted(this.testName(testResult));
        String simpleName = testResult.getTestClass().getRealClass().getSimpleName();
        RunningTestsRegistry.registerThreadWithTest(this.testName(testResult), simpleName);
    }

    public void onConfigurationSuccess(ITestResult testResult) {
        RunningTestsRegistry.unregisterThreadWithTest();
        this.progressLogger.configurationFinished(this.testName(testResult));
    }

    public void onConfigurationFailure(ITestResult testResult) {
        RunningTestsRegistry.unregisterThreadWithTest();
        if (testResult.getThrowable() != null) {
            this.progressLogger.configurationFailed(this.testName(testResult), testResult.getThrowable());
        }
    }

    public void onConfigurationSkip(ITestResult testResult) {
        if (testResult.getThrowable() != null) {
            this.progressLogger.testIgnored(this.testName(testResult));
        }
    }
}

