/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.test;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.test.skip.OS;

class RunningTestsRegistry {
    private static final long MAX_TEST_SECONDS = TimeUnit.MINUTES.toSeconds(5L);
    private static final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "LongTestsWatcher"));
    private static final Map<Thread, ScheduledFuture<?>> scheduledTasks = new ConcurrentHashMap();

    RunningTestsRegistry() {
    }

    static void unregisterThreadWithTest() {
        ScheduledFuture<?> killTask = scheduledTasks.remove(Thread.currentThread());
        killTask.cancel(true);
    }

    static void registerThreadWithTest(String testName, String simpleName) {
        Thread testThread = Thread.currentThread();
        ScheduledFuture<?> future = executor.schedule(() -> RunningTestsRegistry.killLongTest(testThread, testName, simpleName), MAX_TEST_SECONDS, TimeUnit.SECONDS);
        scheduledTasks.put(testThread, future);
    }

    private static void killLongTest(Thread testThread, String testName, String simpleName) {
        try {
            String safeTestName = testName.replaceAll("[^a-zA-Z0-9=]", "_");
            System.err.printf("Test %s has been running for more than %d seconds. Interrupting the test thread and dumping thread stacks of the test suite process and its children.\n", testName, MAX_TEST_SECONDS);
            String jvmName = ManagementFactory.getRuntimeMXBean().getName();
            String ppid = jvmName.split("@")[0];
            ArrayList<String> pids = new ArrayList<String>(Collections.singleton(ppid));
            for (int index = 0; index < pids.size(); ++index) {
                String pid = pids.get(index);
                if (OS.getCurrentOs() != OS.WINDOWS) {
                    Process ps = new ProcessBuilder(new String[0]).command("ps", "-o", "pid=,comm=", "--ppid", pid).start();
                    try (BufferedReader psOutput = new BufferedReader(new InputStreamReader(ps.getInputStream()));){
                        psOutput.lines().forEach(line -> {
                            String[] pidAndCommand = line.split("\\s+");
                            if (!"ps".equals(pidAndCommand[1].trim())) {
                                pids.add(pidAndCommand[0].trim());
                            }
                        });
                    }
                    ps.waitFor(10L, TimeUnit.SECONDS);
                }
                File dumpFile = new File(String.format("threaddump-%1$s-%2$tY-%2$tm-%2$td-%3$s.txt", safeTestName, new Date(), pid));
                System.out.printf("Dumping thread stacks of process %s to %s\n", pid, dumpFile.getAbsolutePath());
                Process jstack = new ProcessBuilder(new String[0]).command(System.getProperty("java.home") + "/../bin/jstack", pid).redirectOutput(dumpFile).start();
                jstack.waitFor(10L, TimeUnit.SECONDS);
            }
            testThread.interrupt();
            System.out.printf("Interrupted thread %s (%d).\n", testThread.getName(), testThread.getId());
            testThread.join(TimeUnit.SECONDS.toMillis(MAX_TEST_SECONDS) / 10L);
            if (testThread.isAlive()) {
                Process kill;
                ArrayList<String> command;
                if (OS.getCurrentOs() == OS.WINDOWS) {
                    command = new ArrayList<String>(Arrays.asList("taskkill", "/t", "/pid"));
                    for (String pid : pids) {
                        command.add("/pid");
                        command.add(pid);
                    }
                    kill = new ProcessBuilder(new String[0]).command(command).start();
                } else {
                    command = new ArrayList<String>(Collections.singletonList("kill"));
                    command.addAll(pids);
                    kill = new ProcessBuilder(new String[0]).command(command).start();
                }
                kill.waitFor(10L, TimeUnit.SECONDS);
                System.out.printf("Killed processes %s\n", String.join((CharSequence)" ", pids));
            }
        }
        catch (Exception e) {
            System.err.println("Error dumping thread stacks/interrupting threads/killing processes:" + e);
        }
    }
}

