/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.util.concurrent.TimeUnit;
import org.junit.Assert;

public class Eventually {
    public static void eventually(String message, Condition ec, long timeout, long pollInterval, TimeUnit unit) {
        if (pollInterval <= 0L) {
            throw new IllegalArgumentException("Check interval must be positive");
        }
        try {
            long expectedEndTime = System.nanoTime() + TimeUnit.NANOSECONDS.convert(timeout, unit);
            long sleepMillis = TimeUnit.MILLISECONDS.convert(pollInterval, unit);
            while (expectedEndTime - System.nanoTime() > 0L) {
                if (ec.isSatisfied()) {
                    return;
                }
                Thread.sleep(sleepMillis);
            }
            Assert.assertTrue((String)message, (boolean)ec.isSatisfied());
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected!", e);
        }
    }

    public static void eventually(Condition ec) {
        Eventually.eventually(ec, 10000L);
    }

    public static void eventually(Condition ec, long timeoutMillis) {
        Eventually.eventually(ec, timeoutMillis, TimeUnit.MILLISECONDS);
    }

    public static void eventually(String message, Condition ec) {
        Eventually.eventually(message, ec, 10000L, 500L, TimeUnit.MILLISECONDS);
    }

    public static void eventually(Condition ec, long timeout, TimeUnit unit) {
        Eventually.eventually(null, ec, unit.toMillis(timeout), 500L, TimeUnit.MILLISECONDS);
    }

    public static void eventually(Condition ec, long timeout, long pollInterval, TimeUnit unit) {
        Eventually.eventually(null, ec, timeout, pollInterval, unit);
    }

    @FunctionalInterface
    public static interface Condition {
        public boolean isSatisfied() throws Exception;
    }
}

