/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.infinispan.commons.util.HopscotchHashMap;
import org.junit.Assert;
import org.junit.Test;

public class HashMapTest {
    @Test
    public void testCreateHopscotch() {
        this.testCreate((Map<Integer, Integer>)new HopscotchHashMap(32));
    }

    @Test
    public void testCreateHopscotchWithRemovals() {
        this.testCreateWithRemovals((Map<Integer, Integer>)new HopscotchHashMap(32));
    }

    private void testCreate(Map<Integer, Integer> testedMap) {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (int i = 0; i < 10000; ++i) {
            Integer key;
            while (map.containsKey(key = Integer.valueOf(random.nextInt()))) {
            }
            Integer value = random.nextInt();
            testedMap.put(key, value);
            Assert.assertEquals((String)("Contents differs with " + (i + 1) + " entries"), (Object)value, (Object)testedMap.get(key));
            Assert.assertEquals((long)(i + 1), (long)testedMap.size());
            map.put(key, value);
            for (Map.Entry entry : map.entrySet()) {
                Integer actual = testedMap.get(entry.getKey());
                Assert.assertEquals(entry.getValue(), (Object)actual);
            }
        }
        Assert.assertEquals(map, testedMap);
        for (Map.Entry entry : map.entrySet()) {
            testedMap.put((Integer)entry.getKey(), (Integer)entry.getValue());
            Assert.assertEquals((long)map.size(), (long)testedMap.size());
        }
        Assert.assertEquals(map, testedMap);
    }

    private void testCreateWithRemovals(Map<Integer, Integer> testedMap) {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        ThreadLocalRandom random = ThreadLocalRandom.current();
        int[] keys = new int[10000];
        Arrays.fill(keys, -1);
        for (int i = 0; i < 10000; ++i) {
            if (map.size() > 0 && random.nextInt(5) == 0) {
                int ki;
                int key;
                while ((key = keys[ki = random.nextInt(i)]) < 0) {
                }
                keys[ki] = -1;
                Integer value = (Integer)map.remove(key);
                Assert.assertNotNull((Object)value);
                Integer removed = testedMap.remove(key);
                Assert.assertEquals((Object)value, (Object)removed);
                Assert.assertEquals((long)map.size(), (long)testedMap.size());
            } else {
                int key;
                while (map.containsKey(key = Math.abs(random.nextInt()))) {
                }
                Integer value = random.nextInt();
                keys[i] = key;
                testedMap.put(key, value);
                Assert.assertEquals((String)("Contents differs with " + (i + 1) + " entries"), (Object)value, (Object)testedMap.get(key));
                map.put(key, value);
                Assert.assertEquals((long)map.size(), (long)testedMap.size());
            }
            for (Map.Entry entry : map.entrySet()) {
                Assert.assertEquals(entry.getValue(), (Object)testedMap.get(entry.getKey()));
            }
        }
        Assert.assertEquals(map, testedMap);
    }
}

