/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.marshall;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import junit.framework.TestCase;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.JavaSerializationMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.junit.Assert;
import org.junit.Test;

public class JavaSerializationMarshallerTest {
    @Test
    public void testPrimitiveArrays() throws Exception {
        JavaSerializationMarshaller marshaller = new JavaSerializationMarshaller();
        byte[] bytes = marshaller.objectToByteBuffer((Object)new byte[0]);
        Assert.assertArrayEquals((byte[])new byte[0], (byte[])((byte[])marshaller.objectFromByteBuffer(bytes)));
        bytes = marshaller.objectToByteBuffer((Object)new short[0]);
        Assert.assertArrayEquals((short[])new short[0], (short[])((short[])marshaller.objectFromByteBuffer(bytes)));
        bytes = marshaller.objectToByteBuffer((Object)new int[0]);
        Assert.assertArrayEquals((int[])new int[0], (int[])((int[])marshaller.objectFromByteBuffer(bytes)));
        bytes = marshaller.objectToByteBuffer((Object)new long[0]);
        Assert.assertArrayEquals((long[])new long[0], (long[])((long[])marshaller.objectFromByteBuffer(bytes)));
        bytes = marshaller.objectToByteBuffer((Object)new float[0]);
        Assert.assertArrayEquals((float[])new float[0], (float[])((float[])marshaller.objectFromByteBuffer(bytes)), (float)0.0f);
        bytes = marshaller.objectToByteBuffer((Object)new double[0]);
        Assert.assertArrayEquals((double[])new double[0], (double[])((double[])marshaller.objectFromByteBuffer(bytes)), (double)0.0);
        bytes = marshaller.objectToByteBuffer((Object)new char[0]);
        Assert.assertArrayEquals((char[])new char[0], (char[])((char[])marshaller.objectFromByteBuffer(bytes)));
        bytes = marshaller.objectToByteBuffer((Object)new boolean[0]);
        Assert.assertArrayEquals((boolean[])new boolean[0], (boolean[])((boolean[])marshaller.objectFromByteBuffer(bytes)));
    }

    @Test
    public void testBoxedPrimitivesAndArray() throws Exception {
        JavaSerializationMarshaller marshaller = new JavaSerializationMarshaller();
        JavaSerializationMarshallerTest.isMarshallable((Marshaller)marshaller, (byte)127);
        JavaSerializationMarshallerTest.isMarshallable((Marshaller)marshaller, (short)Short.MAX_VALUE);
        JavaSerializationMarshallerTest.isMarshallable((Marshaller)marshaller, Integer.MAX_VALUE);
        JavaSerializationMarshallerTest.isMarshallable((Marshaller)marshaller, Long.MAX_VALUE);
        JavaSerializationMarshallerTest.isMarshallable((Marshaller)marshaller, Float.valueOf(Float.MAX_VALUE));
        JavaSerializationMarshallerTest.isMarshallable((Marshaller)marshaller, Double.MAX_VALUE);
        JavaSerializationMarshallerTest.isMarshallable((Marshaller)marshaller, Character.valueOf('c'));
        JavaSerializationMarshallerTest.isMarshallable((Marshaller)marshaller, "String");
    }

    @Test
    public void testMath() throws Exception {
        JavaSerializationMarshaller marshaller = new JavaSerializationMarshaller();
        JavaSerializationMarshallerTest.isMarshallable((Marshaller)marshaller, BigDecimal.TEN);
        JavaSerializationMarshallerTest.isMarshallable((Marshaller)marshaller, BigInteger.TEN);
    }

    @Test
    public void testDate() throws Exception {
        JavaSerializationMarshaller marshaller = new JavaSerializationMarshaller();
        JavaSerializationMarshallerTest.isMarshallable((Marshaller)marshaller, Instant.now());
    }

    @Test
    public void testCustomClassAndArray() throws Exception {
        JavaSerializationMarshaller marshaller = new JavaSerializationMarshaller();
        byte[] bytes = marshaller.objectToByteBuffer((Object)new CustomClass());
        try {
            marshaller.objectFromByteBuffer(bytes);
            Assert.fail((String)"Expected an exception to be thrown when reading the Serialization bytes");
        }
        catch (CacheException e) {
            TestCase.assertTrue((boolean)e.getMessage().contains("blocked by deserialization white list"));
        }
        marshaller.whiteList.addClasses(new Class[]{CustomClass.class});
        Assert.assertNotNull((Object)marshaller.objectFromByteBuffer(bytes));
        JavaSerializationMarshallerTest.isMarshallable((Marshaller)marshaller, new CustomClass());
    }

    private static <V> void isMarshallable(Marshaller marshaller, V o) throws Exception {
        byte[] bytes = marshaller.objectToByteBuffer(o);
        Assert.assertEquals(o, (Object)marshaller.objectFromByteBuffer(bytes));
        Object[] array = (Object[])Array.newInstance(o.getClass(), 1);
        bytes = marshaller.objectToByteBuffer((Object)array);
        Assert.assertArrayEquals((Object[])array, (Object[])((Object[])marshaller.objectFromByteBuffer(bytes)));
    }

    private static class CustomClass
    implements Serializable {
        private CustomClass() {
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object obj) {
            return obj instanceof CustomClass;
        }
    }
}

