/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.junit.ComparisonFailure;

public class Eventually {
    public static final int DEFAULT_TIMEOUT_MILLIS = 10000;
    public static final int DEFAULT_POLL_INTERVAL_MILLIS = 100;

    public static void eventually(Supplier<AssertionError> assertionErrorSupplier, Condition ec, long timeout, long pollInterval, TimeUnit unit) {
        if (pollInterval <= 0L) {
            throw new IllegalArgumentException("Check interval must be positive");
        }
        try {
            long expectedEndTime = System.nanoTime() + TimeUnit.NANOSECONDS.convert(timeout, unit);
            long sleepMillis = TimeUnit.MILLISECONDS.convert(pollInterval, unit);
            do {
                if (ec.isSatisfied()) {
                    return;
                }
                Thread.sleep(sleepMillis);
            } while (expectedEndTime - System.nanoTime() > 0L);
            throw assertionErrorSupplier.get();
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected!", e);
        }
    }

    public static void eventually(String message, Condition ec, long timeout, long pollInterval, TimeUnit unit) {
        Eventually.eventually(() -> new AssertionError((Object)message), ec, timeout, pollInterval, unit);
    }

    public static void eventually(Condition ec) {
        Eventually.eventually(ec, 10000L);
    }

    public static void eventually(Condition ec, long timeoutMillis) {
        Eventually.eventually(ec, timeoutMillis, TimeUnit.MILLISECONDS);
    }

    public static void eventually(String message, Condition ec) {
        Eventually.eventually(message, ec, 10000L, 100L, TimeUnit.MILLISECONDS);
    }

    public static void eventually(Condition ec, long timeout, TimeUnit unit) {
        Eventually.eventually(() -> new AssertionError(), ec, unit.toMillis(timeout), 100L, TimeUnit.MILLISECONDS);
    }

    public static void eventually(Condition ec, long timeout, long pollInterval, TimeUnit unit) {
        Eventually.eventually(() -> new AssertionError(), ec, timeout, pollInterval, unit);
    }

    public static <T> void eventuallyEquals(T expected, Supplier<T> supplier, long timeout, long pollInterval, TimeUnit unit) {
        if (pollInterval <= 0L) {
            throw new IllegalArgumentException("Check interval must be positive");
        }
        try {
            T value;
            long expectedEndTime = System.nanoTime() + TimeUnit.NANOSECONDS.convert(timeout, unit);
            long sleepMillis = TimeUnit.MILLISECONDS.convert(pollInterval, unit);
            do {
                if (Objects.equals(expected, value = supplier.get())) {
                    return;
                }
                Thread.sleep(sleepMillis);
            } while (expectedEndTime - System.nanoTime() > 0L);
            if (expected instanceof String && value instanceof String) {
                throw new ComparisonFailure(null, (String)expected, (String)value);
            }
            String expectedClass = expected != null ? expected.getClass().getSimpleName() : "";
            String valueClass = value != null ? value.getClass().getSimpleName() : "";
            throw new AssertionError((Object)String.format("expected: %s<%s>, but was %s<%s>", expectedClass, expected, valueClass, value));
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected!", e);
        }
    }

    public static <T> void eventuallyEquals(T expected, Supplier<T> supplier, long timeout, TimeUnit unit) {
        Eventually.eventuallyEquals(expected, supplier, unit.toMillis(timeout), 100L, TimeUnit.MILLISECONDS);
    }

    public static <T> void eventuallyEquals(T expected, Supplier<T> supplier) {
        Eventually.eventuallyEquals(expected, supplier, 10000L, 100L, TimeUnit.MILLISECONDS);
    }

    @FunctionalInterface
    public static interface Condition {
        public boolean isSatisfied() throws Exception;
    }
}

