/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.internal;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.infinispan.commons.executors.NonBlockingThread;
import org.infinispan.commons.util.concurrent.NonBlockingRejectedExecutionHandler;
import reactor.blockhound.BlockHound;
import reactor.blockhound.integration.BlockHoundIntegration;

public class CommonsBlockHoundIntegration
implements BlockHoundIntegration {
    public void applyTo(BlockHound.Builder builder) {
        builder.nonBlockingThreadPredicate(current -> current.or(thread -> thread instanceof NonBlockingThread));
        builder.disallowBlockingCallsInside(NonBlockingRejectedExecutionHandler.class.getName(), "rejectedExecution");
    }

    public static void allowPublicMethodsToBlock(BlockHound.Builder builder, Class<?> clazz) {
        Method[] methods;
        for (Method method : methods = clazz.getMethods()) {
            if (!Modifier.isPublic(method.getModifiers())) continue;
            builder.allowBlockingCallsInside(clazz.getName(), method.getName());
        }
    }
}

