package org.infinispan.commons.logging;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.infinispan.commons.dataconversion.EncodingException;
import org.infinispan.commons.CacheException;
import org.jboss.logging.DelegatingBasicLogger;
import org.infinispan.commons.CacheConfigurationException;
import java.lang.SecurityException;
import java.lang.String;
import java.io.IOException;
import org.jboss.logging.Logger;
import org.infinispan.counter.exception.CounterOutOfBoundsException;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import org.infinispan.commons.dataconversion.MediaType;
import java.lang.Object;
import org.infinispan.counter.exception.CounterException;
import java.util.Arrays;
import java.lang.IllegalArgumentException;
import java.lang.UnsupportedOperationException;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2020-03-23T09:38:05+0000")
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void propertyCouldNotBeReplaced(final String line) {
        super.log.logf(FQCN, WARN, null, propertyCouldNotBeReplaced$str(), line);
    }
    private static final String propertyCouldNotBeReplaced = "ISPN000901: Property %s could not be replaced as intended!";
    protected String propertyCouldNotBeReplaced$str() {
        return propertyCouldNotBeReplaced;
    }
    @Override
    public final void ignoringException(final String methodName, final String exceptionName, final Throwable t) {
        super.log.logf(FQCN, WARN, t, ignoringException$str(), methodName, exceptionName);
    }
    private static final String ignoringException = "ISPN000902: Invocation of %s threw an exception %s. Exception is ignored.";
    protected String ignoringException$str() {
        return ignoringException;
    }
    private static final String sslInitializationException = "ISPN000904: Error while initializing SSL context";
    protected String sslInitializationException$str() {
        return sslInitializationException;
    }
    @Override
    public final CacheConfigurationException sslInitializationException(final Throwable e) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), sslInitializationException$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void unableToLoadClass(final String classname, final String classloaders, final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, unableToLoadClass$str(), classname, classloaders);
    }
    private static final String unableToLoadClass = "ISPN000905: Unable to load %s from any of the following classloaders: %s";
    protected String unableToLoadClass$str() {
        return unableToLoadClass;
    }
    @Override
    public final void unableToConvertStringPropertyToInt(final String value, final int defaultValue) {
        super.log.logf(FQCN, WARN, null, unableToConvertStringPropertyToInt$str(), value, defaultValue);
    }
    private static final String unableToConvertStringPropertyToInt = "ISPN000906: Unable to convert string property [%s] to an int! Using default value of %d";
    protected String unableToConvertStringPropertyToInt$str() {
        return unableToConvertStringPropertyToInt;
    }
    @Override
    public final void unableToConvertStringPropertyToLong(final String value, final long defaultValue) {
        super.log.logf(FQCN, WARN, null, unableToConvertStringPropertyToLong$str(), value, defaultValue);
    }
    private static final String unableToConvertStringPropertyToLong = "ISPN000907: Unable to convert string property [%s] to a long! Using default value of %d";
    protected String unableToConvertStringPropertyToLong$str() {
        return unableToConvertStringPropertyToLong;
    }
    @Override
    public final void unableToConvertStringPropertyToBoolean(final String value, final boolean defaultValue) {
        super.log.logf(FQCN, WARN, null, unableToConvertStringPropertyToBoolean$str(), value, defaultValue);
    }
    private static final String unableToConvertStringPropertyToBoolean = "ISPN000908: Unable to convert string property [%s] to a boolean! Using default value of %b";
    protected String unableToConvertStringPropertyToBoolean$str() {
        return unableToConvertStringPropertyToBoolean;
    }
    private static final String unableToUnwrap = "ISPN000909: Unwrapping %s to a type of %s is not a supported";
    protected String unableToUnwrap$str() {
        return unableToUnwrap;
    }
    @Override
    public final IllegalArgumentException unableToUnwrap(final Object o, final Class<?> clazz) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unableToUnwrap$str(), o, clazz));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String illegalValueThreadPoolParameter = "ISPN000910: Illegal value for thread pool parameter(s) %s, it should be: %s";
    protected String illegalValueThreadPoolParameter$str() {
        return illegalValueThreadPoolParameter;
    }
    @Override
    public final CacheConfigurationException illegalValueThreadPoolParameter(final String parameter, final String requirement) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), illegalValueThreadPoolParameter$str(), parameter, requirement));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToUnwrapAny = "ISPN000911: Unwrapping of any instances in %s to a type of %s is not a supported";
    protected String unableToUnwrapAny$str() {
        return unableToUnwrapAny;
    }
    @Override
    public final IllegalArgumentException unableToUnwrapAny(final String objs, final Class<?> clazz) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unableToUnwrapAny$str(), objs, clazz));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unprotectedAttributeSet = "ISPN000912: Expecting a protected configuration for %s";
    protected String unprotectedAttributeSet$str() {
        return unprotectedAttributeSet;
    }
    @Override
    public final IllegalStateException unprotectedAttributeSet(final String name) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unprotectedAttributeSet$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String protectedAttributeSet = "ISPN000913: Expecting a unprotected configuration for %s";
    protected String protectedAttributeSet$str() {
        return protectedAttributeSet;
    }
    @Override
    public final IllegalStateException protectedAttributeSet(final String name) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), protectedAttributeSet$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String attributeSetDuplicateAttribute = "ISPN000914: Duplicate attribute '%s' in attribute set '%s'";
    protected String attributeSetDuplicateAttribute$str() {
        return attributeSetDuplicateAttribute;
    }
    @Override
    public final IllegalArgumentException attributeSetDuplicateAttribute(final String name, final String setName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), attributeSetDuplicateAttribute$str(), name, setName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noSuchAttribute = "ISPN000915: No such attribute '%s' in attribute set '%s'";
    protected String noSuchAttribute$str() {
        return noSuchAttribute;
    }
    @Override
    public final IllegalArgumentException noSuchAttribute(final String name, final String setName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), noSuchAttribute$str(), name, setName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noAttributeCopierForType = "ISPN000916: No attribute copier for type '%s'";
    protected String noAttributeCopierForType$str() {
        return noAttributeCopierForType;
    }
    @Override
    public final IllegalArgumentException noAttributeCopierForType(final Class<?> klass) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), noAttributeCopierForType$str(), klass));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotFindResource = "ISPN000918: Cannot find resource '%s'";
    protected String cannotFindResource$str() {
        return cannotFindResource;
    }
    @Override
    public final IOException cannotFindResource(final String fileName) {
        final IOException result = new IOException(String.format(getLoggingLocale(), cannotFindResource$str(), fileName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String multipleConfigurationValidationErrors = "ISPN000919: Multiple errors encountered while validating configuration";
    protected String multipleConfigurationValidationErrors$str() {
        return multipleConfigurationValidationErrors;
    }
    @Override
    public final CacheConfigurationException multipleConfigurationValidationErrors() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), multipleConfigurationValidationErrors$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToLoadFileUsingScheme = "ISPN000920: Unable to load file using scheme %s";
    protected String unableToLoadFileUsingScheme$str() {
        return unableToLoadFileUsingScheme;
    }
    @Override
    public final UnsupportedOperationException unableToLoadFileUsingScheme(final String scheme) {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), unableToLoadFileUsingScheme$str(), scheme));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noSuchAliasInKeyStore = "ISPN000921: The alias '%s' does not exist in the key store '%s'";
    protected String noSuchAliasInKeyStore$str() {
        return noSuchAliasInKeyStore;
    }
    @Override
    public final SecurityException noSuchAliasInKeyStore(final String keyAlias, final String keyStoreFileName) {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), noSuchAliasInKeyStore$str(), keyAlias, keyStoreFileName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void errorRollingBack(final Throwable e) {
        super.log.logf(FQCN, ERROR, e, errorRollingBack$str());
    }
    private static final String errorRollingBack = "ISPN000922: Exception during rollback";
    protected String errorRollingBack$str() {
        return errorRollingBack;
    }
    @Override
    public final void errorEnlistingResource(final Throwable e) {
        super.log.logf(FQCN, ERROR, e, errorEnlistingResource$str());
    }
    private static final String errorEnlistingResource = "ISPN000923: Error enlisting resource";
    protected String errorEnlistingResource$str() {
        return errorEnlistingResource;
    }
    @Override
    public final void beforeCompletionFailed(final String synchronization, final Throwable t) {
        super.log.logf(FQCN, ERROR, t, beforeCompletionFailed$str(), synchronization);
    }
    private static final String beforeCompletionFailed = "ISPN000924: beforeCompletion() failed for %s";
    protected String beforeCompletionFailed$str() {
        return beforeCompletionFailed;
    }
    @Override
    public final void unexpectedErrorFromResourceManager(final Throwable t) {
        super.log.logf(FQCN, ERROR, t, unexpectedErrorFromResourceManager$str());
    }
    private static final String unexpectedErrorFromResourceManager = "ISPN000925: Unexpected error from resource manager!";
    protected String unexpectedErrorFromResourceManager$str() {
        return unexpectedErrorFromResourceManager;
    }
    @Override
    public final void afterCompletionFailed(final String synchronization, final Throwable t) {
        super.log.logf(FQCN, ERROR, t, afterCompletionFailed$str(), synchronization);
    }
    private static final String afterCompletionFailed = "ISPN000926: afterCompletion() failed for %s";
    protected String afterCompletionFailed$str() {
        return afterCompletionFailed;
    }
    @Override
    public final void errorCommittingTx(final Throwable e) {
        super.log.logf(FQCN, WARN, e, errorCommittingTx$str());
    }
    private static final String errorCommittingTx = "ISPN000927: exception while committing";
    protected String errorCommittingTx$str() {
        return errorCommittingTx;
    }
    @Override
    public final void xaResourceEndFailed(final String xaResource, final Throwable t) {
        super.log.logf(FQCN, ERROR, t, xaResourceEndFailed$str(), xaResource);
    }
    private static final String xaResourceEndFailed = "ISPN000928: end() failed for %s";
    protected String xaResourceEndFailed$str() {
        return xaResourceEndFailed;
    }
    private static final String missingMediaType = "ISPN000929: MediaType cannot be empty or null!";
    protected String missingMediaType$str() {
        return missingMediaType;
    }
    @Override
    public final EncodingException missingMediaType() {
        final EncodingException result = new EncodingException(String.format(getLoggingLocale(), missingMediaType$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidMediaTypeSubtype = "ISPN000930: MediaType must contain a type and a subtype separated by '/'";
    protected String invalidMediaTypeSubtype$str() {
        return invalidMediaTypeSubtype;
    }
    @Override
    public final EncodingException invalidMediaTypeSubtype() {
        final EncodingException result = new EncodingException(String.format(getLoggingLocale(), invalidMediaTypeSubtype$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidMediaTypeParam = "ISPN000931: Failed to parse MediaType: Invalid param description '%s'";
    protected String invalidMediaTypeParam$str() {
        return invalidMediaTypeParam;
    }
    @Override
    public final EncodingException invalidMediaTypeParam(final String param) {
        final EncodingException result = new EncodingException(String.format(getLoggingLocale(), invalidMediaTypeParam$str(), param));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unquotedMediaTypeParam = "ISPN000932: Unclosed param value quote";
    protected String unquotedMediaTypeParam$str() {
        return unquotedMediaTypeParam;
    }
    @Override
    public final EncodingException unquotedMediaTypeParam() {
        final EncodingException result = new EncodingException(String.format(getLoggingLocale(), unquotedMediaTypeParam$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidCharMediaType = "ISPN000933: Invalid character '%s' found in token '%s'";
    protected String invalidCharMediaType$str() {
        return invalidCharMediaType;
    }
    @Override
    public final EncodingException invalidCharMediaType(final char character, final String token) {
        final EncodingException result = new EncodingException(String.format(getLoggingLocale(), invalidCharMediaType$str(), character, token));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupportedContent = "ISPN000934: Unsupported content '%s'";
    protected String unsupportedContent$str() {
        return unsupportedContent;
    }
    @Override
    public final EncodingException unsupportedContent(final Object content) {
        final EncodingException result = new EncodingException(String.format(getLoggingLocale(), unsupportedContent$str(), content));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidWeight = "ISPN000935: Invalid Weight '%s'. Supported values are between 0 and 1.0";
    protected String invalidWeight$str() {
        return invalidWeight;
    }
    @Override
    public final EncodingException invalidWeight(final Object weight) {
        final EncodingException result = new EncodingException(String.format(getLoggingLocale(), invalidWeight$str(), weight));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String classNotInWhitelist = "ISPN000936: Class '%s' blocked by deserialization white list. Adjust the configuration serialization white list regular expression to include this class.";
    protected String classNotInWhitelist$str() {
        return classNotInWhitelist;
    }
    @Override
    public final CacheException classNotInWhitelist(final String className) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), classNotInWhitelist$str(), className));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidMediaType = "ISPN000937: Invalid media type. Expected '%s' but got '%s'";
    protected String invalidMediaType$str() {
        return invalidMediaType;
    }
    @Override
    public final EncodingException invalidMediaType(final String expected, final String actual) {
        final EncodingException result = new EncodingException(String.format(getLoggingLocale(), invalidMediaType$str(), expected, actual));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidTextContent = "ISPN000938: Invalid text content '%s'";
    protected String invalidTextContent$str() {
        return invalidTextContent;
    }
    @Override
    public final EncodingException invalidTextContent(final Object content) {
        final EncodingException result = new EncodingException(String.format(getLoggingLocale(), invalidTextContent$str(), content));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String conversionNotSupported = "ISPN000939: Conversion of content '%s' from '%s' to '%s' not supported";
    protected String conversionNotSupported$str() {
        return conversionNotSupported;
    }
    @Override
    public final EncodingException conversionNotSupported(final Object content, final String fromMediaType, final String toMediaType) {
        final EncodingException result = new EncodingException(String.format(getLoggingLocale(), conversionNotSupported$str(), content, fromMediaType, toMediaType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotDecodeFormURLContent = "ISPN000940: Invalid application/x-www-form-urlencoded content: '%s'";
    protected String cannotDecodeFormURLContent$str() {
        return cannotDecodeFormURLContent;
    }
    @Override
    public final EncodingException cannotDecodeFormURLContent(final Object content) {
        final EncodingException result = new EncodingException(String.format(getLoggingLocale(), cannotDecodeFormURLContent$str(), content));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorEncoding = "ISPN000941: Error encoding content '%s' to '%s'";
    protected String errorEncoding$str() {
        return errorEncoding;
    }
    @Override
    public final EncodingException errorEncoding(final Object content, final MediaType mediaType) {
        final EncodingException result = new EncodingException(String.format(getLoggingLocale(), errorEncoding$str(), content, mediaType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void unableToConvertStringPropertyToEnum(final String value, final String defaultValue) {
        super.log.logf(FQCN, WARN, null, unableToConvertStringPropertyToEnum$str(), value, defaultValue);
    }
    private static final String unableToConvertStringPropertyToEnum = "ISPN000942: Unable to convert property [%s] to an enum! Using default value of %d";
    protected String unableToConvertStringPropertyToEnum$str() {
        return unableToConvertStringPropertyToEnum;
    }
    private static final String featureDisabled = "ISPN000944: Feature %s is disabled!";
    protected String featureDisabled$str() {
        return featureDisabled;
    }
    @Override
    public final CacheConfigurationException featureDisabled(final String feature) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), featureDisabled$str(), feature));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void openSSLAvailable() {
        super.log.logf(FQCN, INFO, null, openSSLAvailable$str());
    }
    private static final String openSSLAvailable = "ISPN000946: Using OpenSSL Provider";
    protected String openSSLAvailable$str() {
        return openSSLAvailable;
    }
    @Override
    public final void openSSLNotAvailable() {
        super.log.logf(FQCN, INFO, null, openSSLNotAvailable$str());
    }
    private static final String openSSLNotAvailable = "ISPN000947: Using Java SSL Provider";
    protected String openSSLNotAvailable$str() {
        return openSSLNotAvailable;
    }
    private static final String counterOurOfBounds = "ISPN029501: %s reached.";
    protected String counterOurOfBounds$str() {
        return counterOurOfBounds;
    }
    @Override
    public final CounterOutOfBoundsException counterOurOfBounds(final String bound) {
        final CounterOutOfBoundsException result = new CounterOutOfBoundsException(String.format(getLoggingLocale(), counterOurOfBounds$str(), bound));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidCounterType = "ISPN029514: Invalid counter type. Expected=%s but got %s";
    protected String invalidCounterType$str() {
        return invalidCounterType;
    }
    @Override
    public final CounterException invalidCounterType(final String expected, final String actual) {
        final CounterException result = new CounterException(String.format(getLoggingLocale(), invalidCounterType$str(), expected, actual));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String undefinedCounter = "ISPN029516: Counter '%s' is not defined.";
    protected String undefinedCounter$str() {
        return undefinedCounter;
    }
    @Override
    public final CounterException undefinedCounter(final String name) {
        final CounterException result = new CounterException(String.format(getLoggingLocale(), undefinedCounter$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidCounterTypeEncoded = "ISPN029522: WEAK and BOUNDED encoded flag isn't supported!";
    protected String invalidCounterTypeEncoded$str() {
        return invalidCounterTypeEncoded;
    }
    @Override
    public final CounterException invalidCounterTypeEncoded() {
        final CounterException result = new CounterException(String.format(getLoggingLocale(), invalidCounterTypeEncoded$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void cannotLoadMimeTypes(final String mimeTypes) {
        super.log.logf(FQCN, ERROR, null, cannotLoadMimeTypes$str(), mimeTypes);
    }
    private static final String cannotLoadMimeTypes = "ISPN029523: Cannot load %s";
    protected String cannotLoadMimeTypes$str() {
        return cannotLoadMimeTypes;
    }
}
