/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.internal;

import java.lang.reflect.Method;
import org.infinispan.commons.executors.NonBlockingResource;
import org.infinispan.commons.util.concurrent.NonBlockingRejectedExecutionHandler;
import reactor.blockhound.BlockHound;
import reactor.blockhound.integration.BlockHoundIntegration;

public class CommonsBlockHoundIntegration
implements BlockHoundIntegration {
    public void applyTo(BlockHound.Builder builder) {
        builder.nonBlockingThreadPredicate(current -> current.or(thread -> thread.getThreadGroup() instanceof NonBlockingResource));
        builder.disallowBlockingCallsInside(NonBlockingRejectedExecutionHandler.class.getName(), "rejectedExecution");
    }

    public static void allowPublicMethodsToBlock(BlockHound.Builder builder, Class<?> clazz) {
        CommonsBlockHoundIntegration.allowMethodsToBlock(builder, clazz, true);
    }

    public static void allowMethodsToBlock(BlockHound.Builder builder, Class<?> clazz, boolean publicOnly) {
        Method[] methods;
        for (Method method : methods = publicOnly ? clazz.getMethods() : clazz.getDeclaredMethods()) {
            builder.allowBlockingCallsInside(clazz.getName(), method.getName());
        }
    }
}

