/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.ServiceLoader;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslServerFactory;

public final class SaslUtils {
    public static Collection<SaslServerFactory> getSaslServerFactories(ClassLoader classLoader, boolean includeGlobal) {
        return SaslUtils.getFactories(SaslServerFactory.class, classLoader, includeGlobal);
    }

    public static Collection<SaslServerFactory> getSaslServerFactories() {
        return SaslUtils.getFactories(SaslServerFactory.class, null, true);
    }

    public static Collection<SaslClientFactory> getSaslClientFactories(ClassLoader classLoader, boolean includeGlobal) {
        return SaslUtils.getFactories(SaslClientFactory.class, classLoader, includeGlobal);
    }

    public static Collection<SaslClientFactory> getSaslClientFactories() {
        return SaslUtils.getFactories(SaslClientFactory.class, null, true);
    }

    private static <T> Collection<T> getFactories(Class<T> type, ClassLoader classLoader, boolean includeGlobal) {
        LinkedHashSet<Object> factories = new LinkedHashSet<Object>();
        ServiceLoader<T> loader = ServiceLoader.load(type, classLoader);
        for (T factory : loader) {
            factories.add(factory);
        }
        if (includeGlobal) {
            Provider[] providers;
            for (Provider currentProvider : providers = Security.getProviders()) {
                for (Provider.Service service : currentProvider.getServices()) {
                    if (!type.getSimpleName().equals(service.getType())) continue;
                    try {
                        factories.add(service.newInstance(null));
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
                }
            }
        }
        return factories;
    }
}

