/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.marshall;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import org.infinispan.commons.configuration.ClassAllowList;
import org.infinispan.commons.logging.Log;

public class CheckedInputStream
extends ObjectInputStream {
    private final ClassAllowList whitelist;

    public CheckedInputStream(InputStream in, ClassAllowList whitelist) throws IOException {
        super(in);
        this.whitelist = whitelist;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        boolean safeClass = this.whitelist.isSafeClass(desc.getName());
        if (!safeClass) {
            throw Log.CONTAINER.classNotInAllowList(desc.getName());
        }
        return super.resolveClass(desc);
    }
}

