/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.IntConsumer;
import org.infinispan.commons.util.EmptyIntSet;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.RangeSet;
import org.infinispan.commons.util.SingletonIntSet;
import org.infinispan.commons.util.SmallIntSet;
import org.junit.Assert;
import org.junit.Test;

public class EmptyIntSetTest {
    IntSet es = EmptyIntSet.getInstance();

    @Test
    public void testSize() {
        Assert.assertEquals((long)0L, (long)this.es.size());
    }

    @Test
    public void testIsEmpty() {
        Assert.assertTrue((boolean)this.es.isEmpty());
    }

    @Test
    public void testContains() throws Exception {
        Assert.assertFalse((boolean)this.es.contains(5));
        Assert.assertFalse((boolean)this.es.contains(3));
    }

    @Test
    public void testContains1() throws Exception {
        Assert.assertFalse((boolean)this.es.contains((Object)5));
        Assert.assertFalse((boolean)this.es.contains((Object)3));
    }

    @Test
    public void testIterator() throws Exception {
        PrimitiveIterator.OfInt iterator = this.es.iterator();
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testToArray() throws Exception {
        Object[] array = this.es.toArray();
        Assert.assertEquals((long)0L, (long)array.length);
    }

    @Test
    public void testToArray1() throws Exception {
        Object[] array = this.es.toArray((Object[])new Integer[1]);
        Assert.assertEquals((long)1L, (long)array.length);
        Assert.assertEquals(null, (Object)array[0]);
        array = this.es.toArray((Object[])new Integer[0]);
        Assert.assertEquals((long)0L, (long)array.length);
    }

    @Test
    public void testToIntArray() throws Exception {
        int[] array = this.es.toIntArray();
        Assert.assertEquals((long)0L, (long)array.length);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testAdd() throws Exception {
        this.es.add(1);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testAdd1() throws Exception {
        this.es.add((Object)1);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testSet() throws Exception {
        this.es.set(1);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testRemove() throws Exception {
        this.es.remove(3);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testRemove1() throws Exception {
        this.es.remove((Object)3);
    }

    @Test
    public void testContainsAll() throws Exception {
        SingletonIntSet sis2 = new SingletonIntSet(3);
        Assert.assertFalse((boolean)this.es.containsAll((IntSet)sis2));
        Assert.assertTrue((boolean)sis2.containsAll(this.es));
        RangeSet sis3 = new RangeSet(0);
        Assert.assertTrue((boolean)sis3.containsAll(this.es));
        Assert.assertTrue((boolean)this.es.containsAll((IntSet)sis3));
    }

    @Test
    public void testContainsAll1() throws Exception {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(3);
        Assert.assertFalse((boolean)this.es.containsAll(hashSet));
        Assert.assertTrue((boolean)hashSet.containsAll((Collection<?>)this.es));
        hashSet.remove(3);
        Assert.assertTrue((boolean)hashSet.containsAll((Collection<?>)this.es));
        Assert.assertTrue((boolean)this.es.containsAll(hashSet));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testAddAll() throws Exception {
        RangeSet rs = new RangeSet(5);
        this.es.addAll((IntSet)rs);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testAddAll1() throws Exception {
        SmallIntSet sis2 = new SmallIntSet();
        this.es.addAll((IntSet)sis2);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testAddAll2() throws Exception {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(1);
        hashSet.add(4);
        this.es.addAll(hashSet);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testRemoveAll() throws Exception {
        RangeSet rs = new RangeSet(6);
        this.es.removeAll((IntSet)rs);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testRemoveAll1() throws Exception {
        Set hashSet = Collections.emptySet();
        this.es.removeAll(hashSet);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testRetainAll() throws Exception {
        RangeSet rs = new RangeSet(5);
        this.es.retainAll((IntSet)rs);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testRetainAll1() throws Exception {
        Set hashSet = Collections.emptySet();
        this.es.retainAll(hashSet);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testClear() throws Exception {
        this.es.clear();
    }

    @Test
    public void testIntStream() throws Exception {
        Assert.assertEquals((long)0L, (long)this.es.intStream().count());
    }

    @Test
    public void testEquals() throws Exception {
        SingletonIntSet sis2 = new SingletonIntSet(4);
        Assert.assertNotEquals((Object)this.es, (Object)sis2);
        Assert.assertNotEquals((Object)sis2, (Object)this.es);
        SmallIntSet sis3 = new SmallIntSet(2);
        Assert.assertEquals((Object)sis3, (Object)this.es);
        Assert.assertEquals((Object)this.es, (Object)sis3);
    }

    @Test
    public void testEquals1() throws Exception {
        SmallIntSet sis2 = new SmallIntSet();
        sis2.add(2);
        Assert.assertNotEquals((Object)this.es, (Object)sis2);
        Assert.assertNotEquals((Object)sis2, (Object)this.es);
        sis2.remove(2);
        Assert.assertEquals((Object)this.es, (Object)sis2);
        Assert.assertEquals((Object)sis2, (Object)this.es);
    }

    @Test
    public void testEquals2() throws Exception {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(2);
        Assert.assertNotEquals((Object)this.es, hashSet);
        Assert.assertNotEquals(hashSet, (Object)this.es);
        hashSet.remove(2);
        Assert.assertEquals((Object)this.es, hashSet);
        Assert.assertEquals(hashSet, (Object)this.es);
    }

    @Test
    public void testForEachPrimitive() {
        HashSet results = new HashSet();
        this.es.forEach(results::add);
        Assert.assertEquals((long)0L, (long)results.size());
    }

    @Test
    public void testForEachObject() {
        HashSet results = new HashSet();
        this.es.forEach(results::add);
        Assert.assertEquals((long)0L, (long)results.size());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testRemoveIfPrimitive() {
        this.es.removeIf(i -> i == 3);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testRemoveIfObject() {
        this.es.removeIf(i -> i == 3);
    }

    @Test
    public void testIntSpliteratorForEachRemaining() {
        HashSet results = new HashSet();
        this.es.intSpliterator().forEachRemaining(results::add);
        Assert.assertEquals((long)0L, (long)results.size());
    }

    @Test
    public void testIntSpliteratorSplitTryAdvance() {
        HashSet results = new HashSet();
        Spliterator.OfInt spliterator = this.es.intSpliterator();
        Spliterator.OfInt split = spliterator.trySplit();
        Assert.assertNull((Object)split);
        IntConsumer consumer = results::add;
        while (spliterator.tryAdvance(consumer)) {
        }
        Assert.assertEquals((long)0L, (long)results.size());
    }
}

