/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.configuration.io.yaml;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Properties;
import org.infinispan.commons.configuration.io.ConfigurationReader;
import org.infinispan.commons.configuration.io.ConfigurationReaderException;
import org.infinispan.commons.configuration.io.ConfigurationResourceResolver;
import org.infinispan.commons.configuration.io.NamingStrategy;
import org.infinispan.commons.configuration.io.PropertyReplacer;
import org.infinispan.commons.configuration.io.URLConfigurationResourceResolver;
import org.infinispan.commons.configuration.io.yaml.YamlConfigurationReader;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.commons.util.Version;
import org.junit.Assert;
import org.junit.Test;

public class YamlConfigurationReaderTest {
    public static final String DEFAULT_NAMESPACE = "urn:infinispan:config:" + Version.getSchemaVersion();
    public static final String SERVER_NAMESPACE = "urn:infinispan:server:" + Version.getSchemaVersion();

    @Test
    public void testLine() {
        YamlConfigurationReader yaml = new YamlConfigurationReader((Reader)new StringReader(""), (ConfigurationResourceResolver)new URLConfigurationResourceResolver(null), new Properties(), PropertyReplacer.DEFAULT, NamingStrategy.KEBAB_CASE);
        YamlConfigurationReader.Parsed p = yaml.parseLine("    key: value");
        Assert.assertEquals((long)4L, (long)p.indent);
        Assert.assertEquals((Object)"key", (Object)p.name);
        Assert.assertEquals((Object)"value", (Object)p.value);
        p = yaml.parseLine("'key': 'value'");
        Assert.assertEquals((long)0L, (long)p.indent);
        Assert.assertEquals((Object)"key", (Object)p.name);
        Assert.assertEquals((Object)"value", (Object)p.value);
        p = yaml.parseLine("    key: value    ");
        Assert.assertEquals((long)4L, (long)p.indent);
        Assert.assertEquals((Object)"key", (Object)p.name);
        Assert.assertEquals((Object)"value", (Object)p.value);
        p = yaml.parseLine("  key:");
        Assert.assertEquals((long)2L, (long)p.indent);
        Assert.assertEquals((Object)"key", (Object)p.name);
        Assert.assertNull((Object)p.value);
        p = yaml.parseLine("  key: # Comment");
        Assert.assertEquals((long)2L, (long)p.indent);
        Assert.assertEquals((Object)"key", (Object)p.name);
        Assert.assertNull((Object)p.value);
        p = yaml.parseLine("  key: value # Comment");
        Assert.assertEquals((long)2L, (long)p.indent);
        Assert.assertEquals((Object)"key", (Object)p.name);
        Assert.assertEquals((Object)"value", (Object)p.value);
        p = yaml.parseLine("  # Comment");
        Assert.assertEquals((long)2L, (long)p.indent);
        Assert.assertNull((Object)p.name);
        Assert.assertNull((Object)p.value);
        p = yaml.parseLine("  - value");
        Assert.assertEquals((long)2L, (long)p.indent);
        Assert.assertTrue((boolean)p.list);
        Assert.assertNull((Object)p.name);
        Assert.assertEquals((Object)"value", (Object)p.value);
        Exceptions.expectException(ConfigurationReaderException.class, () -> yaml.parseLine("  key # comment"));
        Exceptions.expectException(ConfigurationReaderException.class, () -> yaml.parseLine("  key value"));
    }

    @Test
    public void testYamlFile() throws IOException {
        try (InputStreamReader r = new InputStreamReader(YamlConfigurationReaderTest.class.getResourceAsStream("/yaml.yaml"));){
            Properties properties = new Properties();
            properties.put("opinion", "YAML is awful");
            properties.put("fact", "YAML is really awful");
            YamlConfigurationReader yaml = new YamlConfigurationReader((Reader)r, (ConfigurationResourceResolver)new URLConfigurationResourceResolver(null), properties, PropertyReplacer.DEFAULT, NamingStrategy.KEBAB_CASE);
            yaml.require(ConfigurationReader.ElementType.START_DOCUMENT);
            yaml.nextElement();
            yaml.require(ConfigurationReader.ElementType.START_ELEMENT, DEFAULT_NAMESPACE, "item1");
            Assert.assertEquals((long)2L, (long)yaml.getAttributeCount());
            this.assertAttribute(yaml, "item5", "v5");
            this.assertAttribute(yaml, "item6", "v6");
            yaml.nextElement();
            yaml.require(ConfigurationReader.ElementType.START_ELEMENT, DEFAULT_NAMESPACE, "item2");
            Assert.assertEquals((long)4L, (long)yaml.getAttributeCount());
            this.assertAttribute(yaml, "a", "1");
            this.assertAttribute(yaml, "b", "2");
            this.assertAttribute(yaml, "c", "3");
            this.assertAttribute(yaml, "d", "4");
            yaml.nextElement();
            yaml.require(ConfigurationReader.ElementType.START_ELEMENT, DEFAULT_NAMESPACE, "camel-item3");
            Assert.assertEquals((Object)"camel-attribute", (Object)yaml.getAttributeName(1));
            Assert.assertEquals((Object)"YAML is awful", (Object)yaml.getAttributeValue(1));
            Assert.assertEquals((Object)"another-camel-attribute", (Object)yaml.getAttributeName(0));
            Assert.assertEquals((Object)"YAML is really awful", (Object)yaml.getAttributeValue(0));
            yaml.nextElement();
            yaml.require(ConfigurationReader.ElementType.END_ELEMENT, DEFAULT_NAMESPACE, "camel-item3");
            yaml.nextElement();
            yaml.require(ConfigurationReader.ElementType.END_ELEMENT, DEFAULT_NAMESPACE, "item2");
            yaml.nextElement();
            yaml.require(ConfigurationReader.ElementType.START_ELEMENT, DEFAULT_NAMESPACE, "item7");
            Assert.assertEquals((Object)"v7", (Object)yaml.getElementText());
            yaml.nextElement();
            yaml.require(ConfigurationReader.ElementType.END_ELEMENT, DEFAULT_NAMESPACE, "item7");
            yaml.nextElement();
            yaml.require(ConfigurationReader.ElementType.START_ELEMENT, DEFAULT_NAMESPACE, "item7");
            Assert.assertEquals((Object)"v8", (Object)yaml.getElementText());
            yaml.nextElement();
            yaml.require(ConfigurationReader.ElementType.END_ELEMENT, DEFAULT_NAMESPACE, "item7");
            yaml.nextElement();
            yaml.require(ConfigurationReader.ElementType.END_ELEMENT, DEFAULT_NAMESPACE, "item1");
            yaml.nextElement();
            yaml.require(ConfigurationReader.ElementType.END_DOCUMENT);
        }
    }

    private void assertAttribute(YamlConfigurationReader yaml, String name, String value) {
        for (int i = 0; i < yaml.getAttributeCount(); ++i) {
            if (!name.equals(yaml.getAttributeName(i))) continue;
            Assert.assertEquals((Object)value, (Object)yaml.getAttributeValue(i));
            return;
        }
        Assert.fail((String)("Could not find attribute '" + name + " in element '" + yaml.getLocalName() + "'"));
    }
}

