/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.configuration.attributes;

import java.util.Collection;
import org.infinispan.commons.configuration.io.ConfigurationWriter;

public interface AttributeSerializer<T> {
    public static final AttributeSerializer<Object> DEFAULT = (writer, name, value) -> {
        if (Boolean.class == value.getClass()) {
            writer.writeAttribute(name, (boolean)((Boolean)value));
        } else {
            writer.writeAttribute(name, value.toString());
        }
    };
    public static final AttributeSerializer<char[]> SECRET = (writer, name, value) -> {
        if (Boolean.getBoolean("org.infinispan.configuration.clear-text-secrets")) {
            writer.writeAttribute(name, new String((char[])value));
        } else {
            writer.writeAttribute(name, "***");
        }
    };
    public static final AttributeSerializer<String[]> STRING_ARRAY = ConfigurationWriter::writeAttribute;
    public static final AttributeSerializer<Collection<String>> STRING_COLLECTION = (writer, name, value) -> writer.writeAttribute(name, value.toArray(new String[0]));
    public static final AttributeSerializer<Collection<? extends Enum<?>>> ENUM_COLLECTION = (writer, name, value) -> writer.writeAttribute(name, (String[])value.stream().map(Enum::toString).toArray(String[]::new));
    public static final AttributeSerializer<Object> INSTANCE_CLASS_NAME = (writer, name, value) -> writer.writeAttribute(name, value.getClass().getName());
    public static final AttributeSerializer<Class> CLASS_NAME = (writer, name, value) -> writer.writeAttribute(name, value.getName());

    public void serialize(ConfigurationWriter var1, String var2, T var3);
}

