/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.configuration.attributes;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.Matchable;
import org.infinispan.commons.configuration.attributes.Updatable;
import org.infinispan.commons.configuration.io.ConfigurationWriter;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.util.Util;

public abstract class ConfigurationElement<T extends ConfigurationElement>
implements Matchable<T>,
Updatable<T> {
    public static final ConfigurationElement<?>[] CHILDLESS = new ConfigurationElement[0];
    protected final String element;
    protected final AttributeSet attributes;
    protected final ConfigurationElement<?>[] children;
    protected final boolean repeated;

    protected ConfigurationElement(Enum<?> element, AttributeSet attributes, ConfigurationElement<?> ... children) {
        this(element.toString(), false, attributes, children);
    }

    protected ConfigurationElement(String element, AttributeSet attributes, ConfigurationElement<?> ... children) {
        this(element, false, attributes, children);
    }

    protected ConfigurationElement(String element, boolean repeated, AttributeSet attributes, ConfigurationElement<?> ... children) {
        this.element = element;
        this.repeated = repeated;
        this.attributes = attributes.checkProtection();
        this.children = children != null ? children : CHILDLESS;
    }

    public String name() {
        return this.element;
    }

    public final AttributeSet attributes() {
        return this.attributes;
    }

    public ConfigurationElement<?>[] children() {
        return this.children;
    }

    public Attribute<?> findAttribute(String name) {
        int sep = name.indexOf(46);
        if (sep < 0) {
            if (!this.attributes.contains(name)) {
                throw Log.CONFIG.noAttribute(name, this.element);
            }
            return this.attributes.attribute(name);
        }
        String part = name.substring(0, sep);
        for (ConfigurationElement<?> child : this.children) {
            if (!part.equals(child.name())) continue;
            return child.findAttribute(name.substring(sep + 1));
        }
        throw Log.CONFIG.noAttribute(name, this.element);
    }

    protected static <T extends ConfigurationElement> ConfigurationElement<T> list(Enum<?> element, List<T> list) {
        ConfigurationElement[] configurationElements = list.toArray(new ConfigurationElement[0]);
        return new ConfigurationElement<T>((Enum)element, AttributeSet.EMPTY, configurationElements){};
    }

    @Override
    public boolean matches(T other) {
        if (!this.attributes.matches(((ConfigurationElement)other).attributes)) {
            return false;
        }
        if (this.children.length != ((ConfigurationElement)other).children.length) {
            return false;
        }
        for (int i = 0; i < this.children.length; ++i) {
            ConfigurationElement<?> ours = this.children[i];
            ConfigurationElement<?> theirs = ((ConfigurationElement)other).children[i];
            if (ours.matches(theirs)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void update(T other) {
        this.attributes.update(((ConfigurationElement)other).attributes);
        for (int i = 0; i < this.children.length; ++i) {
            ConfigurationElement<?> ours = this.children[i];
            ConfigurationElement<?> theirs = ((ConfigurationElement)other).children[i];
            ours.update(theirs);
        }
    }

    @Override
    public void validateUpdate(T other) {
        IllegalArgumentException iae = new IllegalArgumentException();
        try {
            this.attributes.validateUpdate(((ConfigurationElement)other).attributes);
        }
        catch (Throwable t) {
            Util.unwrapSuppressed(iae, t);
        }
        for (int i = 0; i < this.children.length; ++i) {
            ConfigurationElement<?> ours = this.children[i];
            ConfigurationElement<?> theirs = ((ConfigurationElement)other).children[i];
            try {
                ours.validateUpdate(theirs);
                continue;
            }
            catch (Throwable t) {
                Util.unwrapSuppressed(iae, t);
            }
        }
        if (iae.getSuppressed().length > 0) {
            throw iae;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigurationElement that = (ConfigurationElement)o;
        return this.attributes.equals(that.attributes) && Arrays.equals(this.children, that.children);
    }

    public int hashCode() {
        int result = Objects.hash(this.attributes);
        result = 31 * result + Arrays.hashCode(this.children);
        return result;
    }

    public String toString() {
        return this.attributes.toString();
    }

    public boolean isModified() {
        if (this.attributes.isModified()) {
            return true;
        }
        for (ConfigurationElement<?> child : this.children) {
            if (!child.isModified()) continue;
            return true;
        }
        return false;
    }

    public void write(ConfigurationWriter writer) {
        if (this.isModified()) {
            writer.writeStartElement(this.element);
            this.attributes.write(writer);
            String repeatElement = null;
            for (ConfigurationElement<?> child : this.children) {
                if (child.repeated) {
                    if (!child.element.equals(repeatElement)) {
                        if (repeatElement != null) {
                            writer.writeEndListElement();
                        }
                        repeatElement = child.element;
                        writer.writeStartListElement(repeatElement, true);
                    }
                } else {
                    repeatElement = null;
                }
                child.write(writer);
            }
            if (repeatElement != null) {
                writer.writeEndListElement();
            }
            writer.writeEndElement();
        }
    }

    protected static <T> ConfigurationElement<?>[] children(Collection<T> children) {
        return children.toArray(CHILDLESS);
    }

    protected static ConfigurationElement<?> child(Attribute<?> attribute) {
        return new AttributeAsElement(attribute);
    }

    private static class AttributeAsElement
    extends ConfigurationElement<AttributeAsElement> {
        private final Attribute<?> attribute;

        protected AttributeAsElement(Attribute<?> attribute) {
            super(attribute.name(), false, AttributeSet.EMPTY, CHILDLESS);
            this.attribute = attribute;
        }

        @Override
        public void write(ConfigurationWriter writer) {
            this.attribute.write(writer, this.attribute.name());
        }
    }
}

