/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.configuration.io.yaml;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import org.infinispan.commons.configuration.io.AbstractConfigurationWriter;
import org.infinispan.commons.configuration.io.ConfigurationFormatFeature;
import org.infinispan.commons.configuration.io.ConfigurationWriterException;
import org.infinispan.commons.configuration.io.NamingStrategy;

public class YamlConfigurationWriter
extends AbstractConfigurationWriter {
    public static final int INDENT = 2;
    private boolean openTag;
    private boolean attributes;

    public YamlConfigurationWriter(Writer writer) {
        super(writer, 2, true, NamingStrategy.CAMEL_CASE);
    }

    @Override
    public void writeStartDocument() {
    }

    @Override
    public void writeStartElement(String name) {
        this.writeStartElement0(new AbstractConfigurationWriter.Tag(name, false, true, true), this.naming);
    }

    private void writeStartElement0(AbstractConfigurationWriter.Tag tag, NamingStrategy naming) {
        try {
            if (this.openTag) {
                this.nl();
            }
            AbstractConfigurationWriter.Tag parent = (AbstractConfigurationWriter.Tag)this.tagStack.peek();
            this.tagStack.push(tag);
            this.tab();
            if (parent != null && parent.isRepeating()) {
                this.writer.write("- ");
            } else {
                this.writeName(tag.getName(), naming);
            }
            this.openTag = true;
            this.attributes = false;
            this.indent();
        }
        catch (IOException e) {
            throw new ConfigurationWriterException(e);
        }
    }

    private void writeName(String name, NamingStrategy naming) throws IOException {
        this.writer.write(naming.convert(name));
        this.writer.write(": ");
    }

    @Override
    public void writeStartElement(String prefix, String namespace, String name) {
        this.writeStartElement(this.prefixName(prefix, namespace, name));
    }

    private String prefixName(String prefix, String namespace, String name) {
        if (prefix == null) {
            return name;
        }
        if (this.namespaces.containsKey(prefix)) {
            return prefix + ":" + name;
        }
        return namespace + ":" + name;
    }

    @Override
    public void writeStartArrayElement(String name) {
        this.writeStartElement0(new AbstractConfigurationWriter.Tag(name, true, true, false), this.naming);
    }

    @Override
    public void writeEndArrayElement() {
        this.writeEndElement();
    }

    @Override
    public void writeStartListElement(String name, boolean explicit) {
        this.writeStartElement0(new AbstractConfigurationWriter.Tag(name, true, explicit, true), this.naming);
    }

    @Override
    public void writeStartListElement(String prefix, String namespace, String name, boolean explicit) {
        this.writeStartListElement(this.prefixName(prefix, namespace, name), explicit);
    }

    @Override
    public void writeNamespace(String prefix, String namespace) {
        if (!this.openTag) {
            throw new ConfigurationWriterException("Cannot set namespace without a started element");
        }
    }

    @Override
    public void writeDefaultNamespace(String namespace) {
        if (!this.openTag) {
            throw new ConfigurationWriterException("Cannot set namespace without a started element");
        }
    }

    @Override
    public void writeEndElement() {
        this.openTag = false;
        this.attributes = false;
        this.tagStack.pop();
        this.outdent();
    }

    @Override
    public void writeEndDocument() {
        if (!this.tagStack.isEmpty()) {
            throw new ConfigurationWriterException("Tag stack not empty: " + this.tagStack);
        }
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw new ConfigurationWriterException(e);
        }
    }

    @Override
    public void writeAttribute(String name, String value) {
        try {
            this.openTag = false;
            if (!this.attributes) {
                this.nl();
                this.attributes = true;
            }
            this.tab();
            this.writer.write(this.naming.convert(name));
            this.writer.write(": \"");
            this.writer.write(value);
            this.writer.write(34);
            this.nl();
        }
        catch (IOException e) {
            throw new ConfigurationWriterException(e);
        }
    }

    @Override
    public void writeAttribute(String name, String[] values) {
        try {
            this.openTag = false;
            if (!this.attributes) {
                this.nl();
                this.attributes = true;
            }
            this.tab();
            this.writer.write(this.naming.convert(name));
            this.writer.write(":");
            this.nl();
            this.indent();
            for (String value : values) {
                this.tab();
                this.writer.write("- \"");
                this.writer.write(value);
                this.writer.write(34);
                this.nl();
            }
            this.outdent();
            this.nl();
        }
        catch (IOException e) {
            throw new ConfigurationWriterException(e);
        }
    }

    @Override
    public void writeArrayElement(String outer, String inner, String attribute, Iterable<String> values) {
        try {
            Iterator<String> it = values.iterator();
            if (it.hasNext()) {
                this.writeStartElement(outer);
                this.nl();
                while (it.hasNext()) {
                    this.tab();
                    this.writer.write("- \"");
                    this.writer.write(it.next());
                    this.writer.write(34);
                    this.nl();
                }
                this.writeEndElement();
            }
        }
        catch (IOException e) {
            throw new ConfigurationWriterException(e);
        }
    }

    @Override
    public void writeCharacters(String chars) {
        try {
            if (this.attributes) {
                this.writeAttribute("value", chars);
            } else {
                this.writer.write("\"");
                this.writer.write(chars);
                this.writer.write(34);
                this.nl();
            }
        }
        catch (IOException e) {
            throw new ConfigurationWriterException(e);
        }
    }

    @Override
    public void writeEmptyElement(String name) {
        try {
            this.writeStartElement(name);
            this.writer.write(126);
            this.nl();
            this.writeEndElement();
        }
        catch (IOException e) {
            throw new ConfigurationWriterException(e);
        }
    }

    @Override
    public void writeComment(String comment) {
        try {
            this.writer.write("# ");
            this.writer.write(comment);
            this.nl();
        }
        catch (IOException e) {
            throw new ConfigurationWriterException(e);
        }
    }

    @Override
    public void writeStartMap(String name) {
        this.writeStartElement(name);
    }

    @Override
    public void writeMapItem(String element, String name, String key, String value) {
        this.writeAttribute(key, value);
    }

    @Override
    public void writeMapItem(String element, String name, String key) {
        this.writeStartElement0(new AbstractConfigurationWriter.Tag(key, false, true, true), NamingStrategy.IDENTITY);
        this.writeStartElement(element);
    }

    @Override
    public void writeEndMapItem() {
        this.writeEndElement();
        this.writeEndElement();
    }

    @Override
    public void writeEndMap() {
        this.writeEndElement();
    }

    @Override
    public boolean hasFeature(ConfigurationFormatFeature feature) {
        return false;
    }
}

