/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Random;
import java.util.UUID;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.util.Util;
import org.junit.Assert;
import org.junit.Test;

public class MarshallUtilTest {
    private static final int NR_RANDOM = 1000;

    private static void positiveRange(int min, int max, int bytesExpected, ObjectInputOutput io) throws IOException {
        for (int i = min; i > 0 && i < max; i <<= 1) {
            MarshallUtilTest.checkIntAndByteArray(i, bytesExpected, io);
        }
    }

    private static void checkIntAndByteArray(int i, int bytesExpected, ObjectInputOutput io) throws IOException {
        io.reset();
        MarshallUtil.marshallSize((ObjectOutput)io, (int)i);
        Assert.assertEquals((String)("Error for i=" + i), (long)bytesExpected, (long)io.buffer.size());
        Assert.assertEquals((String)("Error for i=" + i), (long)i, (long)MarshallUtil.unmarshallSize((ObjectInput)io));
        Assert.assertEquals((String)("Error for i=" + i), (long)0L, (long)io.buffer.size());
    }

    private static void checkNegativeInt(int i, ObjectInputOutput io) throws IOException {
        io.reset();
        MarshallUtil.marshallSize((ObjectOutput)io, (int)i);
        Assert.assertEquals((String)("Error for i=" + i), (long)1L, (long)io.buffer.size());
        Assert.assertEquals((String)("Error for i=" + i), (long)-1L, (long)MarshallUtil.unmarshallSize((ObjectInput)io));
        Assert.assertEquals((String)("Error for i=" + i), (long)0L, (long)io.buffer.size());
    }

    @Test
    public void testPositiveRange() throws IOException {
        ObjectInputOutput io = new ObjectInputOutput();
        MarshallUtilTest.checkIntAndByteArray(0, 1, io);
        MarshallUtilTest.positiveRange(1, 64, 1, io);
        MarshallUtilTest.positiveRange(64, 8192, 2, io);
        MarshallUtilTest.positiveRange(8192, 0x100000, 3, io);
        MarshallUtilTest.positiveRange(0x100000, 0x8000000, 4, io);
        MarshallUtilTest.positiveRange(0x8000000, Integer.MAX_VALUE, 5, io);
        MarshallUtilTest.checkIntAndByteArray(Integer.MAX_VALUE, 5, io);
    }

    @Test
    public void testNegativeRange() throws IOException {
        int v;
        ObjectInputOutput io = new ObjectInputOutput();
        for (int i = 1; i < Integer.MAX_VALUE && (v = -i) < 0; i <<= 1) {
            MarshallUtilTest.checkNegativeInt(v, io);
        }
        MarshallUtilTest.checkNegativeInt(Integer.MIN_VALUE, io);
    }

    @Test
    public void testRandomPositiveInt() throws IOException {
        Random random = new Random(System.nanoTime());
        ObjectInputOutput io = new ObjectInputOutput();
        for (int i = 0; i < 1000; ++i) {
            int v = random.nextInt();
            if (v < 0) {
                v = -v;
            }
            io.reset();
            MarshallUtil.marshallSize((ObjectOutput)io, (int)v);
            Assert.assertEquals((String)("Error for v=" + v), (long)v, (long)MarshallUtil.unmarshallSize((ObjectInput)io));
        }
    }

    @Test
    public void testRandomNegativeInt() throws IOException {
        Random random = new Random(System.nanoTime());
        ObjectInputOutput io = new ObjectInputOutput();
        for (int i = 0; i < 1000; ++i) {
            int v = random.nextInt();
            if (v > 0) {
                v = -v;
            } else if (v == 0) {
                --i;
                continue;
            }
            io.reset();
            MarshallUtil.marshallSize((ObjectOutput)io, (int)v);
            Assert.assertEquals((String)("Error for v=" + v), (long)-1L, (long)MarshallUtil.unmarshallSize((ObjectInput)io));
        }
    }

    @Test
    public void testEnum() throws IOException {
        ObjectInputOutput io = new ObjectInputOutput();
        MarshallUtil.marshallEnum(null, (ObjectOutput)io);
        Assert.assertNull((Object)MarshallUtil.unmarshallEnum((ObjectInput)io, ordinal -> TestEnum.values()[ordinal]));
        Assert.assertEquals((long)0L, (long)io.buffer.size());
        for (TestEnum e : TestEnum.values()) {
            io.reset();
            MarshallUtil.marshallEnum((Enum)e, (ObjectOutput)io);
            Assert.assertEquals((Object)((Object)e), (Object)MarshallUtil.unmarshallEnum((ObjectInput)io, ordinal -> TestEnum.values()[ordinal]));
            Assert.assertEquals((long)0L, (long)io.buffer.size());
        }
    }

    @Test
    public void testUUID() throws IOException {
        UUID uuid;
        int i;
        ObjectInputOutput io = new ObjectInputOutput();
        MarshallUtil.marshallUUID(null, (ObjectOutput)io, (boolean)true);
        Assert.assertNull((Object)MarshallUtil.unmarshallUUID((ObjectInput)io, (boolean)true));
        Assert.assertEquals((long)0L, (long)io.buffer.size());
        for (i = 0; i < 1000; ++i) {
            io.reset();
            uuid = Util.threadLocalRandomUUID();
            MarshallUtil.marshallUUID((UUID)uuid, (ObjectOutput)io, (boolean)false);
            Assert.assertEquals((Object)uuid, (Object)MarshallUtil.unmarshallUUID((ObjectInput)io, (boolean)false));
            Assert.assertEquals((long)0L, (long)io.buffer.size());
        }
        for (i = 0; i < 1000; ++i) {
            io.reset();
            uuid = Util.threadLocalRandomUUID();
            MarshallUtil.marshallUUID((UUID)uuid, (ObjectOutput)io, (boolean)true);
            Assert.assertEquals((Object)uuid, (Object)MarshallUtil.unmarshallUUID((ObjectInput)io, (boolean)true));
            Assert.assertEquals((long)0L, (long)io.buffer.size());
        }
    }

    @Test
    public void testArray() throws IOException, ClassNotFoundException {
        ObjectInputOutput io = new ObjectInputOutput();
        MarshallUtil.marshallArray(null, (ObjectOutput)io);
        Assert.assertNull((Object)MarshallUtil.unmarshallArray((ObjectInput)io, null));
        Assert.assertEquals((long)0L, (long)io.buffer.size());
        io.reset();
        Object[] array = new String[]{};
        MarshallUtil.marshallArray((Object[])array, (ObjectOutput)io);
        Assert.assertTrue((boolean)Arrays.equals(array, MarshallUtil.unmarshallArray((ObjectInput)io, Util::stringArray)));
        Assert.assertEquals((long)0L, (long)io.buffer.size());
        io.reset();
        array = new String[]{"a", "b", "c"};
        MarshallUtil.marshallArray((Object[])array, (ObjectOutput)io);
        Assert.assertTrue((boolean)Arrays.equals(array, MarshallUtil.unmarshallArray((ObjectInput)io, Util::stringArray)));
        Assert.assertEquals((long)0L, (long)io.buffer.size());
        io.reset();
    }

    @Test
    public void testByteArray() throws IOException, ClassNotFoundException {
        ObjectInputOutput io = new ObjectInputOutput();
        MarshallUtil.marshallByteArray(null, (ObjectOutput)io);
        Assert.assertNull((Object)MarshallUtil.unmarshallByteArray((ObjectInput)io));
        Assert.assertEquals((long)0L, (long)io.buffer.size());
        io.reset();
        byte[] array = Util.EMPTY_BYTE_ARRAY;
        MarshallUtil.marshallByteArray((byte[])array, (ObjectOutput)io);
        Assert.assertTrue((boolean)Arrays.equals(array, MarshallUtil.unmarshallByteArray((ObjectInput)io)));
        Assert.assertEquals((long)0L, (long)io.buffer.size());
        io.reset();
        array = new byte[]{1, 2, 3};
        MarshallUtil.marshallByteArray((byte[])array, (ObjectOutput)io);
        Assert.assertTrue((boolean)Arrays.equals(array, MarshallUtil.unmarshallByteArray((ObjectInput)io)));
        Assert.assertEquals((long)0L, (long)io.buffer.size());
        io.reset();
    }

    private static class ObjectInputOutput
    implements ObjectOutput,
    ObjectInput {
        private final Queue<Object> buffer = new LinkedList<Object>();

        private ObjectInputOutput() {
        }

        @Override
        public void writeByte(int v) throws IOException {
            this.buffer.add((byte)v);
        }

        @Override
        public void writeShort(int v) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeChar(int v) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeInt(int v) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeLong(long v) throws IOException {
            this.buffer.add(v);
        }

        @Override
        public void writeFloat(float v) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeDouble(double v) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeBytes(String s) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeChars(String s) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeUTF(String s) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void reset() {
            this.buffer.clear();
        }

        @Override
        public Object readObject() throws ClassNotFoundException, IOException {
            return this.buffer.poll();
        }

        @Override
        public int read() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int read(byte[] b) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long skip(long n) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int available() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void readFully(byte[] b) throws IOException {
            byte[] array = (byte[])this.buffer.poll();
            Assert.assertEquals((long)array.length, (long)b.length);
            System.arraycopy(array, 0, b, 0, b.length);
        }

        @Override
        public void readFully(byte[] b, int off, int len) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int skipBytes(int n) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean readBoolean() throws IOException {
            return (Boolean)this.buffer.poll();
        }

        @Override
        public byte readByte() throws IOException {
            return (Byte)this.buffer.poll();
        }

        @Override
        public int readUnsignedByte() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public short readShort() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int readUnsignedShort() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public char readChar() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int readInt() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long readLong() throws IOException {
            return (Long)this.buffer.poll();
        }

        @Override
        public float readFloat() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public double readDouble() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public String readLine() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public String readUTF() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeObject(Object obj) throws IOException {
            this.buffer.add(obj);
        }

        @Override
        public void write(int b) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.buffer.add(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeBoolean(boolean v) throws IOException {
            this.buffer.add(v);
        }

        @Override
        public void flush() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    private static enum TestEnum {
        ONE,
        TWO,
        THREE;

    }
}

