/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.time;

import java.time.Instant;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.time.DefaultTimeService;

public class ControlledTimeService
extends DefaultTimeService {
    private static final Log log = LogFactory.getLog(ControlledTimeService.class);
    private final Object id;
    protected volatile long currentMillis;

    public ControlledTimeService() {
        this(null);
    }

    public ControlledTimeService(Object id) {
        this(id, 1000000L);
    }

    public ControlledTimeService(Object id, ControlledTimeService other) {
        this(id, other.currentMillis);
    }

    public ControlledTimeService(Object id, long currentMillis) {
        this.id = id;
        this.currentMillis = currentMillis;
    }

    public long wallClockTime() {
        return this.currentMillis;
    }

    public long time() {
        return TimeUnit.MILLISECONDS.toNanos(this.currentMillis);
    }

    public Instant instant() {
        return Instant.ofEpochMilli(this.currentMillis);
    }

    public void advance(long delta, TimeUnit timeUnit) {
        this.advance(timeUnit.toMillis(delta));
    }

    public synchronized void advance(long deltaMillis) {
        if (deltaMillis <= 0L) {
            throw new IllegalArgumentException("Argument must be greater than 0");
        }
        this.currentMillis += deltaMillis;
        log.tracef("Current time for %s is now %d", this.id, (Object)this.currentMillis);
    }
}

