/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.IntConsumer;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.RangeSet;
import org.infinispan.commons.util.SingletonIntSet;
import org.infinispan.commons.util.SmallIntSet;
import org.infinispan.commons.util.Util;
import org.junit.Assert;
import org.junit.Test;

public class SingletonIntSetTest {
    @Test
    public void testSize() {
        SingletonIntSet rs = new SingletonIntSet(3);
        Assert.assertEquals((long)1L, (long)rs.size());
    }

    @Test
    public void testIsEmpty() {
        SingletonIntSet rs = new SingletonIntSet(3);
        Assert.assertFalse((boolean)rs.isEmpty());
    }

    @Test
    public void testContains() throws Exception {
        SingletonIntSet sis = new SingletonIntSet(3);
        Assert.assertFalse((boolean)sis.contains(5));
        Assert.assertTrue((boolean)sis.contains(3));
    }

    @Test
    public void testContains1() throws Exception {
        SingletonIntSet sis = new SingletonIntSet(3);
        Assert.assertFalse((boolean)sis.contains((Object)5));
        Assert.assertTrue((boolean)sis.contains((Object)3));
    }

    @Test
    public void testIterator() throws Exception {
        SingletonIntSet sis = new SingletonIntSet(3);
        PrimitiveIterator.OfInt iterator = sis.iterator();
        Assert.assertEquals((long)3L, (long)iterator.nextInt());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testToArray() throws Exception {
        SingletonIntSet sis = new SingletonIntSet(3);
        Object[] array = sis.toArray();
        Assert.assertEquals((long)1L, (long)array.length);
        Assert.assertEquals((Object)3, (Object)array[0]);
    }

    @Test
    public void testToArray1() throws Exception {
        SingletonIntSet sis = new SingletonIntSet(3);
        Object[] array = sis.toArray((Object[])new Integer[1]);
        Assert.assertEquals((long)1L, (long)array.length);
        Assert.assertEquals((Object)3, (Object)array[0]);
    }

    @Test
    public void testToIntArray() throws Exception {
        SingletonIntSet sis = new SingletonIntSet(3);
        int[] array = sis.toIntArray();
        Assert.assertArrayEquals((int[])new int[]{3}, (int[])array);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testAdd() throws Exception {
        SingletonIntSet sis = new SingletonIntSet(3);
        sis.add(1);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testAdd1() throws Exception {
        SingletonIntSet sis = new SingletonIntSet(3);
        sis.add((Object)1);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testSet() throws Exception {
        SingletonIntSet sis = new SingletonIntSet(3);
        sis.set(1);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testRemove() throws Exception {
        SingletonIntSet sis = new SingletonIntSet(3);
        sis.remove(3);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testRemove1() throws Exception {
        SingletonIntSet sis = new SingletonIntSet(3);
        sis.remove((Object)3);
    }

    @Test
    public void testContainsAll() throws Exception {
        SingletonIntSet sis = new SingletonIntSet(3);
        SingletonIntSet sis2 = new SingletonIntSet(3);
        Assert.assertTrue((boolean)sis.containsAll((IntSet)sis2));
        Assert.assertTrue((boolean)sis2.containsAll((IntSet)sis));
        RangeSet sis3 = new RangeSet(4);
        Assert.assertTrue((boolean)sis3.containsAll((IntSet)sis));
        Assert.assertFalse((boolean)sis.containsAll((IntSet)sis3));
    }

    @Test
    public void testContainsAll1() throws Exception {
        SingletonIntSet sis = new SingletonIntSet(3);
        HashSet<Integer> hashSet = new HashSet<Integer>(Arrays.asList(3));
        Assert.assertTrue((boolean)sis.containsAll(hashSet));
        Assert.assertTrue((boolean)hashSet.containsAll((Collection<?>)sis));
        hashSet.add(0);
        Assert.assertTrue((boolean)hashSet.containsAll((Collection<?>)sis));
        Assert.assertFalse((boolean)sis.containsAll(hashSet));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testAddAll() throws Exception {
        SingletonIntSet sis = new SingletonIntSet(3);
        RangeSet rs = new RangeSet(5);
        sis.addAll((IntSet)rs);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testAddAll1() throws Exception {
        SingletonIntSet sis = new SingletonIntSet(3);
        SmallIntSet sis2 = new SmallIntSet();
        sis.addAll((IntSet)sis2);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testAddAll2() throws Exception {
        Set hashSet = Util.asSet((Object[])new Integer[]{1, 4});
        SingletonIntSet sis = new SingletonIntSet(3);
        sis.addAll((Collection)hashSet);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testRemoveAll() throws Exception {
        SingletonIntSet sis = new SingletonIntSet(3);
        RangeSet rs = new RangeSet(6);
        sis.removeAll((IntSet)rs);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testRemoveAll1() throws Exception {
        SingletonIntSet sis = new SingletonIntSet(3);
        HashSet hashSet = new HashSet();
        sis.removeAll(hashSet);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testRetainAll() throws Exception {
        SingletonIntSet sis = new SingletonIntSet(3);
        RangeSet rs = new RangeSet(5);
        sis.retainAll((IntSet)rs);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testRetainAll1() throws Exception {
        SingletonIntSet sis = new SingletonIntSet(3);
        SingletonIntSet sis2 = new SingletonIntSet(3);
        sis.retainAll((IntSet)sis2);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testRetainAll2() throws Exception {
        SingletonIntSet sis = new SingletonIntSet(3);
        HashSet hashSet = new HashSet();
        sis.retainAll(hashSet);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testClear() throws Exception {
        SingletonIntSet sis = new SingletonIntSet(3);
        sis.clear();
    }

    @Test
    public void testIntStream() throws Exception {
        SingletonIntSet sis = new SingletonIntSet(3);
        Assert.assertEquals((long)1L, (long)sis.intStream().count());
    }

    @Test
    public void testEquals() throws Exception {
        SingletonIntSet sis = new SingletonIntSet(3);
        SingletonIntSet sis2 = new SingletonIntSet(4);
        Assert.assertNotEquals((Object)sis, (Object)sis2);
        Assert.assertNotEquals((Object)sis2, (Object)sis);
        SmallIntSet sis3 = SmallIntSet.of((int)3);
        Assert.assertEquals((Object)sis3, (Object)sis);
        Assert.assertEquals((Object)sis, (Object)sis3);
    }

    @Test
    public void testEquals1() throws Exception {
        SingletonIntSet sis = new SingletonIntSet(3);
        SmallIntSet sis2 = new SmallIntSet();
        sis2.add(2);
        sis2.add(3);
        Assert.assertNotEquals((Object)sis, (Object)sis2);
        Assert.assertNotEquals((Object)sis2, (Object)sis);
        sis2.remove(2);
        Assert.assertEquals((Object)sis, (Object)sis2);
        Assert.assertEquals((Object)sis2, (Object)sis);
    }

    @Test
    public void testEquals2() throws Exception {
        SingletonIntSet sis = new SingletonIntSet(3);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(2);
        hashSet.add(3);
        Assert.assertNotEquals((Object)sis, hashSet);
        Assert.assertNotEquals(hashSet, (Object)sis);
        hashSet.remove(2);
        Assert.assertEquals((Object)sis, hashSet);
        Assert.assertEquals(hashSet, (Object)sis);
    }

    @Test
    public void testForEachPrimitive() {
        SingletonIntSet sis = new SingletonIntSet(3);
        HashSet results = new HashSet();
        sis.forEach(results::add);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertTrue((boolean)results.contains(3));
    }

    @Test
    public void testForEachObject() {
        SingletonIntSet sis = new SingletonIntSet(3);
        HashSet results = new HashSet();
        sis.forEach(results::add);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertTrue((boolean)results.contains(3));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testRemoveIfPrimitive() {
        SingletonIntSet sis = new SingletonIntSet(3);
        sis.removeIf(i -> i == 3);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testRemoveIfObject() {
        SingletonIntSet sis = new SingletonIntSet(3);
        sis.removeIf(i -> i == 3);
    }

    @Test
    public void testIntSpliteratorForEachRemaining() {
        SingletonIntSet sis = new SingletonIntSet(3);
        HashSet results = new HashSet();
        sis.intSpliterator().forEachRemaining(results::add);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertTrue((boolean)results.contains(3));
    }

    @Test
    public void testIntSpliteratorSplitTryAdvance() {
        SingletonIntSet sis = new SingletonIntSet(3);
        HashSet results = new HashSet();
        Spliterator.OfInt spliterator = sis.intSpliterator();
        Spliterator.OfInt split = spliterator.trySplit();
        Assert.assertNull((Object)split);
        IntConsumer consumer = results::add;
        while (spliterator.tryAdvance(consumer)) {
        }
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertTrue((boolean)results.contains(3));
    }

    @Test
    public void testToBitSet() {
        this.testToArray(0);
        this.testToArray(12);
        this.testToArray(16);
        this.testToArray(43);
        this.testToArray(5);
    }

    private void testToArray(int bitToSet) {
        BitSet bitSet = new BitSet();
        bitSet.set(bitToSet);
        SingletonIntSet sis = new SingletonIntSet(bitToSet);
        Assert.assertArrayEquals((byte[])bitSet.toByteArray(), (byte[])sis.toBitSet());
    }
}

