/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Set;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.Util;

public class ByteBuffer {
    private final byte[] buf;
    private final int offset;
    private final int length;

    public ByteBuffer(byte[] buf, int offset, int length) {
        this.buf = buf;
        this.offset = offset;
        this.length = length;
    }

    public byte[] getBuf() {
        return this.buf;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public ByteBuffer copy() {
        int new_length;
        byte[] new_buf = this.buf != null ? new byte[this.length] : null;
        int n = new_length = new_buf != null ? new_buf.length : 0;
        if (new_buf != null) {
            System.arraycopy(this.buf, this.offset, new_buf, 0, this.length);
        }
        return new ByteBuffer(new_buf, 0, new_length);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.length).append(" bytes");
        if (this.offset > 0) {
            sb.append(" (offset=").append(this.offset).append(")");
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ByteBuffer)) {
            return false;
        }
        ByteBuffer that = (ByteBuffer)o;
        return Arrays.equals(this.copy().getBuf(), that.copy().getBuf());
    }

    public int hashCode() {
        return Arrays.hashCode(this.copy().getBuf());
    }

    public InputStream getStream() {
        return new ByteArrayInputStream(this.getBuf(), this.getOffset(), this.getLength());
    }

    public java.nio.ByteBuffer toJDKByteBuffer() {
        return java.nio.ByteBuffer.wrap(this.buf, this.offset, this.length);
    }

    public void copy(byte[] result, int offset) {
        System.arraycopy(this.buf, offset, result, offset, this.length);
    }

    public static class Externalizer
    extends AbstractExternalizer<ByteBuffer> {
        private static final long serialVersionUID = -5291318076267612501L;

        @Override
        public void writeObject(ObjectOutput output, ByteBuffer b) throws IOException {
            UnsignedNumeric.writeUnsignedInt(output, b.length);
            output.write(b.buf, b.offset, b.length);
        }

        @Override
        public ByteBuffer readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            int length = UnsignedNumeric.readUnsignedInt(input);
            byte[] data = new byte[length];
            input.read(data, 0, length);
            return new ByteBuffer(data, 0, length);
        }

        @Override
        public Integer getId() {
            return 106;
        }

        @Override
        public Set<Class<? extends ByteBuffer>> getTypeClasses() {
            return Util.asSet(ByteBuffer.class);
        }
    }
}

