/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.configuration.attributes;

import java.util.Properties;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeInitializer;
import org.infinispan.commons.configuration.attributes.AttributeListener;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.junit.Assert;
import org.junit.Test;

public class AttributeTest {
    @Test
    public void testAttributeDefinitionType() {
        AttributeDefinition def = AttributeDefinition.builder((String)"long", (Object)10L).build();
        Assert.assertEquals(Long.class, (Object)def.getType());
        AttributeDefinition def2 = AttributeDefinition.builder((String)"string", null, String.class).build();
        Assert.assertEquals(String.class, (Object)def2.getType());
    }

    @Test
    public void testAttributeSetProtection() {
        AttributeDefinition immutable = AttributeDefinition.builder((String)"immutable", (Object)"").immutable().build();
        AttributeDefinition mutable = AttributeDefinition.builder((String)"mutable", (Object)"").build();
        AttributeSet set = new AttributeSet(this.getClass(), new AttributeDefinition[]{immutable, mutable});
        set.attribute(immutable).set((Object)"an immutable string");
        set.attribute(mutable).set((Object)"a mutable string");
        set = set.protect();
        try {
            set.attribute(immutable).set((Object)"this should fail");
            Assert.fail((String)"Changing an immutable attribute on a protected set should fail");
        }
        catch (Exception e) {
            // empty catch block
        }
        set.attribute(mutable).set((Object)"this should work");
    }

    @Test
    public void testAttributeChanges() {
        AttributeDefinition def = AttributeDefinition.builder((String)"test", (Object)false).build();
        Attribute attribute = def.toAttribute();
        Assert.assertFalse((boolean)attribute.isModified());
        attribute.set((Object)true);
        Assert.assertEquals((Object)true, (Object)attribute.get());
        Assert.assertTrue((boolean)attribute.isModified());
    }

    @Test
    public void testAttributeInitializer() {
        AttributeDefinition def = AttributeDefinition.builder((String)"props", null, Properties.class).initializer((AttributeInitializer)new AttributeInitializer<Properties>(){

            public Properties initialize() {
                return new Properties();
            }
        }).build();
        Attribute attribute1 = def.toAttribute();
        Attribute attribute2 = def.toAttribute();
        Assert.assertTrue((attribute1.get() != attribute2.get() ? 1 : 0) != 0);
    }

    @Test
    public void testAttributeListener() {
        AttributeDefinition def = AttributeDefinition.builder((String)"test", (Object)false).build();
        Attribute attribute = def.toAttribute();
        final Holder<Boolean> listenerInvoked = new Holder<Boolean>(false);
        attribute.addListener((AttributeListener)new AttributeListener<Boolean>(){

            public void attributeChanged(Attribute<Boolean> attribute, Boolean oldValue) {
                Assert.assertTrue((boolean)((Boolean)attribute.get()));
                Assert.assertFalse((boolean)oldValue);
                listenerInvoked.set(true);
            }
        });
        attribute.set((Object)true);
        Assert.assertTrue((String)"Attribute listener was not invoked", (boolean)listenerInvoked.get());
    }

    static class Holder<T> {
        T object;

        Holder(T object) {
            this.object = object;
        }

        Holder() {
            this.object = null;
        }

        T get() {
            return this.object;
        }

        void set(T object) {
            this.object = object;
        }
    }
}

