/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.infinispan.commons.io.SignedNumeric;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SignedNumericTest {
    @Test
    public void testEncodeDecode() throws Exception {
        this.encodeDecode(-2147483647, 5);
        this.encodeDecode(-2500000, 4);
        this.encodeDecode(-15000, 3);
        this.encodeDecode(-100, 2);
        this.encodeDecode(-1, 1);
        this.encodeDecode(0, 1);
        this.encodeDecode(1, 1);
        this.encodeDecode(60, 1);
        this.encodeDecode(128, 2);
        this.encodeDecode(1300, 2);
        this.encodeDecode(15000, 3);
        this.encodeDecode(2500000, 4);
        this.encodeDecode(0x7FFFFFFE, 5);
    }

    private void encodeDecode(int value, int expectedSize) throws IOException {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream(5);){
            SignedNumeric.writeSignedInt((OutputStream)os, (int)value);
            byte[] bytes = os.toByteArray();
            try (ByteArrayInputStream is = new ByteArrayInputStream(bytes);){
                int read = SignedNumeric.readSignedInt((InputStream)is);
                Assert.assertEquals((int)read, (int)value);
            }
            Assert.assertEquals((int)bytes.length, (int)expectedSize);
        }
    }
}

