/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.configuration.attributes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeCopier;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeInitializer;
import org.infinispan.commons.configuration.attributes.AttributeListener;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.TypedPropertiesAttributeCopier;
import org.infinispan.commons.util.TypedProperties;
import org.junit.Assert;
import org.junit.Test;

public class AttributeTest {
    @Test
    public void testAttributeDefinitionType() {
        AttributeDefinition def = AttributeDefinition.builder((String)"long", (Object)10L).build();
        Assert.assertEquals(Long.class, (Object)def.getType());
        AttributeDefinition def2 = AttributeDefinition.builder((String)"string", null, String.class).build();
        Assert.assertEquals(String.class, (Object)def2.getType());
    }

    @Test
    public void testAttributeSetProtection() {
        AttributeDefinition immutable = AttributeDefinition.builder((String)"immutable", (Object)"").immutable().build();
        AttributeDefinition mutable = AttributeDefinition.builder((String)"mutable", (Object)"").build();
        AttributeSet set = new AttributeSet(this.getClass(), new AttributeDefinition[]{immutable, mutable});
        set.attribute(immutable).set((Object)"an immutable string");
        set.attribute(mutable).set((Object)"a mutable string");
        set = set.protect();
        try {
            set.attribute(immutable).set((Object)"this should fail");
            Assert.fail((String)"Changing an immutable attribute on a protected set should fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
        set.attribute(mutable).set((Object)"this should work");
    }

    @Test
    public void testAttributeChanges() {
        AttributeDefinition def = AttributeDefinition.builder((String)"test", (Object)false).build();
        Attribute attribute = def.toAttribute();
        Assert.assertFalse((boolean)attribute.isModified());
        attribute.set((Object)true);
        Assert.assertEquals((Object)true, (Object)attribute.get());
        Assert.assertTrue((boolean)attribute.isModified());
    }

    @Test
    public void testAttributeInitializer() {
        AttributeDefinition def = AttributeDefinition.builder((String)"props", null, Properties.class).initializer((AttributeInitializer)new AttributeInitializer<Properties>(){

            public Properties initialize() {
                return new Properties();
            }
        }).build();
        Attribute attribute1 = def.toAttribute();
        Attribute attribute2 = def.toAttribute();
        Assert.assertTrue((attribute1.get() != attribute2.get() ? 1 : 0) != 0);
    }

    @Test
    public void testDefaultAttributeCopy() {
        AttributeDefinition def = AttributeDefinition.builder((String)"test", (Object)false).build();
        AttributeSet set1 = new AttributeSet("set", new AttributeDefinition[]{def});
        set1.attribute(def).set((Object)true);
        AttributeSet set2 = new AttributeSet("set", new AttributeDefinition[]{def});
        set2.read(set1);
        Assert.assertEquals((Object)set1.attribute(def).get(), (Object)set2.attribute(def).get());
    }

    @Test
    public void testCollectionAttributeCopy() {
        AttributeDefinition def = AttributeDefinition.builder((String)"properties", null, TypedProperties.class).copier(TypedPropertiesAttributeCopier.INSTANCE).initializer((AttributeInitializer)new AttributeInitializer<TypedProperties>(){

            public TypedProperties initialize() {
                return new TypedProperties();
            }
        }).build();
        AttributeSet set1 = new AttributeSet("set", new AttributeDefinition[]{def});
        TypedProperties typedProperties = (TypedProperties)set1.attribute(def).get();
        typedProperties.setProperty("key", "value");
        set1.attribute(def).set((Object)typedProperties);
        set1 = set1.protect();
        typedProperties = (TypedProperties)set1.attribute(def).get();
        typedProperties.setProperty("key", "anotherValue");
        AttributeSet set2 = new AttributeSet("set", new AttributeDefinition[]{def});
        set2.read(set1);
    }

    @Test
    public void testCustomAttributeCopier() {
        AttributeDefinition def = AttributeDefinition.builder((String)"test", Arrays.asList("a", "b")).copier((AttributeCopier)new AttributeCopier<List<String>>(){

            public List<String> copyAttribute(List<String> attribute) {
                if (attribute == null) {
                    return null;
                }
                return new ArrayList<String>(attribute);
            }
        }).build();
        AttributeSet set1 = new AttributeSet("set", new AttributeDefinition[]{def});
        set1.attribute(def).set(Arrays.asList("b", "a"));
        AttributeSet set2 = new AttributeSet("set", new AttributeDefinition[]{def});
        set2.read(set1);
        Assert.assertEquals((Object)set1.attribute(def).get(), (Object)set2.attribute(def).get());
        Assert.assertFalse((set1.attribute(def).get() == set2.attribute(def).get() ? 1 : 0) != 0);
    }

    @Test
    public void testAttributeListener() {
        AttributeDefinition def = AttributeDefinition.builder((String)"test", (Object)false).build();
        Attribute attribute = def.toAttribute();
        final Holder<Boolean> listenerInvoked = new Holder<Boolean>(false);
        attribute.addListener((AttributeListener)new AttributeListener<Boolean>(){

            public void attributeChanged(Attribute<Boolean> attribute, Boolean oldValue) {
                Assert.assertTrue((boolean)((Boolean)attribute.get()));
                Assert.assertFalse((boolean)oldValue);
                listenerInvoked.set(true);
            }
        });
        attribute.set((Object)true);
        Assert.assertTrue((String)"Attribute listener was not invoked", (boolean)listenerInvoked.get());
    }

    static class Holder<T> {
        T object;

        Holder(T object) {
            this.object = object;
        }

        Holder() {
            this.object = null;
        }

        T get() {
            return this.object;
        }

        void set(T object) {
            this.object = object;
        }
    }
}

