/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;

public final class InfinispanCollections {
    private InfinispanCollections() {
    }

    public static <K, V, E> Map<K, V> transformMapValue(Map<K, E> input, Function<E, V> f) {
        if (input.isEmpty()) {
            return Collections.emptyMap();
        }
        if (input.size() == 1) {
            Map.Entry<K, E> single = input.entrySet().iterator().next();
            return Collections.singletonMap(single.getKey(), f.transform(single.getValue()));
        }
        HashMap<K, V> copy = new HashMap<K, V>(input.size());
        for (Map.Entry<K, E> entry : input.entrySet()) {
            copy.put(entry.getKey(), f.transform(entry.getValue()));
        }
        return Collections.unmodifiableMap(copy);
    }

    public static <K, V, E> Map<K, V> transformCollectionToMap(Collection<? extends E> input, MapMakerFunction<K, V, ? super E> f) {
        if (input.isEmpty()) {
            return Collections.emptyMap();
        }
        if (input.size() == 1) {
            E single = input.iterator().next();
            Map.Entry<K, V> entry = f.transform(single);
            return Collections.singletonMap(entry.getKey(), entry.getValue());
        }
        HashMap<K, V> map = new HashMap<K, V>(input.size());
        for (E e : input) {
            Map.Entry<K, V> entry = f.transform(e);
            map.put(entry.getKey(), entry.getValue());
        }
        return Collections.unmodifiableMap(map);
    }

    public static <E> Set<E> difference(Set<? extends E> s1, Set<? extends E> s2) {
        HashSet<E> copy1 = new HashSet<E>(s1);
        copy1.removeAll(new HashSet<E>(s2));
        return copy1;
    }

    public static <T> boolean containsAny(Collection<T> haystack, Collection<T> needles) {
        for (T element : needles) {
            if (!haystack.contains(element)) continue;
            return true;
        }
        return false;
    }

    public static <T> void forEach(T[] array, Consumer<T> consumer) {
        int size = Objects.requireNonNull(array, "Array must be non-null.").length;
        for (int i = 0; i < size; ++i) {
            consumer.accept(array[i]);
        }
    }

    public static void assertNotNullEntries(Map<?, ?> map, String name) {
        Objects.requireNonNull(map, () -> "Map '" + name + "' must be non null.");
        Supplier<String> keySupplier = () -> "Map '" + name + "' contains null key.";
        Supplier<String> valueSupplier = () -> "Map '" + name + "' contains null value.";
        map.forEach((k, v) -> {
            Objects.requireNonNull(k, keySupplier);
            Objects.requireNonNull(v, valueSupplier);
        });
    }

    public static void assertNotNullEntries(Collection<?> collection, String name) {
        Objects.requireNonNull(collection, () -> "Collection '" + name + "' must be non null.");
        Supplier<String> entrySupplier = () -> "Collection '" + name + "' contains null entry.";
        collection.forEach(k -> Objects.requireNonNull(k, entrySupplier));
    }

    public static interface MapMakerFunction<K, V, E> {
        public Map.Entry<K, V> transform(E var1);
    }

    public static interface Function<E, T> {
        public T transform(E var1);
    }
}

