/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.dataconversion;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.infinispan.commons.dataconversion.EncodingException;
import org.infinispan.commons.dataconversion.MediaType;
import org.junit.Assert;
import org.junit.Test;

public class MediaTypeTest {
    @Test
    public void testParsingTypeSubType() throws Exception {
        MediaType appJson = MediaType.fromString((String)"application/json");
        this.assertMediaTypeNoParams(appJson, "application", "json");
    }

    @Test(expected=EncodingException.class)
    public void testParsingEmpty() throws Exception {
        MediaType.fromString((String)"");
    }

    @Test(expected=EncodingException.class)
    public void testParsingNoSubType() throws Exception {
        MediaType.fromString((String)"something");
    }

    @Test(expected=EncodingException.class)
    public void testParsingNoSubType2() throws Exception {
        MediaType.fromString((String)"application; charset=utf-8");
    }

    @Test(expected=EncodingException.class)
    public void testParsingNull() throws Exception {
        MediaType.fromString(null);
    }

    @Test
    public void testParsingEmptySpaces() throws Exception {
        MediaType appJson = MediaType.fromString((String)"application /json");
        this.assertMediaTypeNoParams(appJson, "application", "json");
    }

    @Test
    public void testParsingEmptySpaces2() throws Exception {
        MediaType appJson = MediaType.fromString((String)"application/ json");
        this.assertMediaTypeNoParams(appJson, "application", "json");
    }

    @Test
    public void testParsingEmptySpaces3() throws Exception {
        MediaType appJson = MediaType.fromString((String)"application  / json");
        this.assertMediaTypeNoParams(appJson, "application", "json");
    }

    @Test
    public void testQuotedParams() throws Exception {
        MediaType mediaType = MediaType.fromString((String)"application/json; charset=\"UTF-8\"");
        this.assertMediaTypeWithParam(mediaType, "application", "json", "charset", "UTF-8");
    }

    @Test
    public void testQuotedParams2() throws Exception {
        MediaType mediaType = MediaType.fromString((String)"application/json; charset='UTF-8'");
        this.assertMediaTypeWithParam(mediaType, "application", "json", "charset", "UTF-8");
    }

    @Test
    public void testUnQuotedParam() throws Exception {
        MediaType mediaType = MediaType.fromString((String)"application/json; charset=UTF-8");
        this.assertMediaTypeWithParam(mediaType, "application", "json", "charset", "UTF-8");
    }

    @Test
    public void testToString() throws Exception {
        Assert.assertEquals((Object)"text/csv", (Object)new MediaType("text", "csv").toString());
        Assert.assertEquals((Object)"foo/bar; a=2", (Object)new MediaType("foo", "bar", MediaTypeTest.createMap(new MapEntry("a", "2"))).toString());
        Assert.assertEquals((Object)"foo/bar; a=2; b=1; c=2", (Object)new MediaType("foo", "bar", MediaTypeTest.createMap(new MapEntry("a", "2"), new MapEntry("b", "1"), new MapEntry("c", "2"))).toString());
    }

    @Test
    public void testUnQuotedParamWithSpaces() throws Exception {
        MediaType mediaType = MediaType.fromString((String)"application/json ; charset= UTF-8");
        this.assertMediaTypeWithParam(mediaType, "application", "json", "charset", "UTF-8");
    }

    @Test(expected=EncodingException.class)
    public void testWrongQuoting() throws Exception {
        MediaType.fromString((String)"application/json ; charset= \"UTF-8");
    }

    @Test
    public void testMultipleParameters() throws Exception {
        MediaType mediaType = MediaType.fromString((String)"application/json ; charset=UTF-8; param1=value1; param2 = value2");
        this.assertMediaTypeWithParams(mediaType, "application", "json", new String[]{"charset", "param1", "param2"}, new String[]{"UTF-8", "value1", "value2"});
    }

    @Test(expected=EncodingException.class)
    public void testMultipleParametersWrongSeparator() throws Exception {
        MediaType.fromString((String)"application/json ; charset=UTF-8; param1=value1, param2 = value2");
    }

    private void assertMediaTypeNoParams(MediaType mediaType, String type, String subType) {
        Assert.assertEquals((Object)type, (Object)mediaType.getType());
        Assert.assertEquals((Object)subType, (Object)mediaType.getSubType());
        Assert.assertFalse((boolean)mediaType.hasParameters());
        Assert.assertEquals(Optional.empty(), (Object)mediaType.getParameter("a"));
    }

    private void assertMediaTypeWithParam(MediaType mediaType, String type, String subType, String paramName, String paramValue) {
        this.assertMediaTypeWithParams(mediaType, type, subType, new String[]{paramName}, new String[]{paramValue});
    }

    private void assertMediaTypeWithParams(MediaType mediaType, String type, String subType, String[] paramNames, String[] paramValues) {
        Assert.assertEquals((Object)type, (Object)mediaType.getType());
        Assert.assertEquals((Object)subType, (Object)mediaType.getSubType());
        Assert.assertTrue((boolean)mediaType.hasParameters());
        for (int i = 0; i < paramNames.length; ++i) {
            String paramName = paramNames[i];
            String paramValue = paramValues[i];
            Assert.assertEquals(Optional.of(paramValue), (Object)mediaType.getParameter(paramName));
        }
    }

    private static Map<String, String> createMap(MapEntry ... entries) {
        HashMap<String, String> map = new HashMap<String, String>();
        Arrays.stream(entries).forEach(e -> map.put(e.getKey(), e.getValue()));
        return map;
    }

    private class MapEntry {
        private String key;
        private String value;

        String getKey() {
            return this.key;
        }

        String getValue() {
            return this.value;
        }

        MapEntry(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }
}

