/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.dataconversion;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.stream.Stream;
import org.infinispan.commons.dataconversion.EncodingException;
import org.infinispan.commons.dataconversion.MediaType;
import org.junit.Assert;
import org.junit.Test;

public class MediaTypeTest {
    @Test
    public void testParsingTypeSubType() {
        MediaType appJson = MediaType.fromString((String)"application/json");
        this.assertMediaTypeNoParams(appJson, "application", "json");
    }

    @Test(expected=EncodingException.class)
    public void testParsingEmpty() {
        MediaType.fromString((String)"");
    }

    @Test(expected=EncodingException.class)
    public void testParsingNoSubType() {
        MediaType.fromString((String)"something");
    }

    @Test(expected=EncodingException.class)
    public void testParsingNoSubType2() {
        MediaType.fromString((String)"application; charset=utf-8");
    }

    @Test(expected=EncodingException.class)
    public void testParsingNull() {
        MediaType.fromString(null);
    }

    @Test
    public void testParsingEmptySpaces() {
        MediaType appJson = MediaType.fromString((String)"application /json");
        this.assertMediaTypeNoParams(appJson, "application", "json");
    }

    @Test
    public void testParsingEmptySpaces2() {
        MediaType appJson = MediaType.fromString((String)"application/ json");
        this.assertMediaTypeNoParams(appJson, "application", "json");
    }

    @Test
    public void testParsingEmptySpaces3() {
        MediaType appJson = MediaType.fromString((String)"application  / json");
        this.assertMediaTypeNoParams(appJson, "application", "json");
    }

    @Test
    public void testQuotedParams() {
        MediaType mediaType = MediaType.fromString((String)"application/json; charset=\"UTF-8\"");
        this.assertMediaTypeWithParam(mediaType, "application", "json", "charset", "UTF-8");
    }

    @Test
    public void testQuotedParams2() {
        MediaType mediaType = MediaType.fromString((String)"application/json; charset='UTF-8'");
        this.assertMediaTypeWithParam(mediaType, "application", "json", "charset", "UTF-8");
    }

    @Test
    public void testUnQuotedParam() {
        MediaType mediaType = MediaType.fromString((String)"application/json; charset=UTF-8");
        this.assertMediaTypeWithParam(mediaType, "application", "json", "charset", "UTF-8");
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)"application/xml", (Object)new MediaType("application", "xml", MediaTypeTest.createMap(new MapEntry("q", "0.9"))).toString());
        Assert.assertEquals((Object)"text/csv", (Object)new MediaType("text", "csv").toString());
        Assert.assertEquals((Object)"foo/bar; a=2", (Object)new MediaType("foo", "bar", MediaTypeTest.createMap(new MapEntry("a", "2"))).toString());
        Assert.assertEquals((Object)"foo/bar; a=2; b=1; c=2", (Object)new MediaType("foo", "bar", MediaTypeTest.createMap(new MapEntry("a", "2"), new MapEntry("b", "1"), new MapEntry("c", "2"))).toString());
        Assert.assertEquals((Object)"a/b; p=1", (Object)MediaType.fromString((String)"a/b; p=1; q=2;").toStringExcludingParam(new String[]{"q"}));
    }

    @Test
    public void testUnQuotedParamWithSpaces() {
        MediaType mediaType = MediaType.fromString((String)"application/json ; charset= UTF-8");
        this.assertMediaTypeWithParam(mediaType, "application", "json", "charset", "UTF-8");
    }

    @Test(expected=EncodingException.class)
    public void testWrongQuoting() {
        MediaType.fromString((String)"application/json ; charset= \"UTF-8");
    }

    @Test
    public void testMultipleParameters() {
        MediaType mediaType = MediaType.fromString((String)"application/json ; charset=UTF-8; param1=value1; param2 = value2");
        this.assertMediaTypeWithParams(mediaType, "application", "json", new String[]{"charset", "param1", "param2"}, new String[]{"UTF-8", "value1", "value2"});
    }

    @Test(expected=EncodingException.class)
    public void testMultipleParametersWrongSeparator() {
        MediaType.fromString((String)"application/json ; charset=UTF-8; param1=value1, param2 = value2");
    }

    @Test
    public void testParseWeight() {
        MediaType mediaType = MediaType.fromString((String)"application/json ; q=0.8");
        Assert.assertEquals((double)0.8, (double)mediaType.getWeight(), (double)0.0);
    }

    @Test(expected=EncodingException.class)
    public void testParseInvalidWeight() {
        MediaType.fromString((String)"application/json ; q=high");
    }

    @Test
    public void testDefaultWeight() {
        MediaType mediaType = MediaType.fromString((String)"application/json");
        Assert.assertEquals((double)1.0, (double)mediaType.getWeight(), (double)0.0);
    }

    @Test
    public void testWildCard() {
        MediaType mediaType = MediaType.fromString((String)"*/*");
        Assert.assertEquals((Object)"*", (Object)mediaType.getType());
        Assert.assertEquals((Object)"*", (Object)mediaType.getSubType());
        Assert.assertTrue((boolean)mediaType.match(MediaType.TEXT_PLAIN));
        Assert.assertTrue((boolean)mediaType.match(MediaType.APPLICATION_PROTOSTREAM));
    }

    @Test
    public void testParseList() {
        Stream mediaTypes = MediaType.parseList((String)"text/html, image/png,*/*");
        Iterator mediaTypeIterator = mediaTypes.iterator();
        Assert.assertEquals((Object)MediaType.TEXT_HTML, mediaTypeIterator.next());
        Assert.assertEquals((Object)MediaType.IMAGE_PNG, mediaTypeIterator.next());
        Assert.assertEquals((Object)MediaType.MATCH_ALL, mediaTypeIterator.next());
        Assert.assertFalse((boolean)mediaTypeIterator.hasNext());
    }

    @Test
    public void testParseBrowserRequest() {
        Stream list = MediaType.parseList((String)"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        Iterator iterator = list.iterator();
        Assert.assertEquals((Object)"text/html", (Object)((MediaType)iterator.next()).getTypeSubtype());
        Assert.assertEquals((Object)"application/xhtml+xml", (Object)((MediaType)iterator.next()).getTypeSubtype());
        Assert.assertEquals((Object)"application/xml", (Object)((MediaType)iterator.next()).getTypeSubtype());
        Assert.assertEquals((Object)"*/*", (Object)((MediaType)iterator.next()).getTypeSubtype());
    }

    @Test
    public void testNegotiations() {
        Stream mediaTypes = MediaType.parseList((String)"text/html; q=0.8,*/*;q=0.2,application/json");
        Iterator iterator = mediaTypes.iterator();
        MediaType preferred = (MediaType)iterator.next();
        MediaType secondChoice = (MediaType)iterator.next();
        MediaType everythingElse = (MediaType)iterator.next();
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON, (Object)preferred);
        Assert.assertEquals((Object)"text/html", (Object)secondChoice.getTypeSubtype());
        Assert.assertEquals((Object)"*/*", (Object)everythingElse.getTypeSubtype());
    }

    @Test
    public void testMediaTypeMatch() {
        MediaType one = MediaType.APPLICATION_INFINISPAN_BINARY;
        MediaType two = MediaType.APPLICATION_INFINISPAN_BINARY;
        Assert.assertTrue((boolean)one.match(two));
        Assert.assertTrue((boolean)two.match(one));
    }

    @Test
    public void testMediaTypeUnMatch() {
        MediaType one = MediaType.APPLICATION_INFINISPAN_BINARY;
        MediaType two = MediaType.APPLICATION_INFINISPAN_MARSHALLED;
        Assert.assertFalse((boolean)one.match(two));
        Assert.assertFalse((boolean)two.match(one));
    }

    @Test
    public void testMediaTypeMatchItself() {
        MediaType one = MediaType.APPLICATION_INFINISPAN_BINARY;
        Assert.assertTrue((boolean)one.match(one));
    }

    @Test
    public void testMediaTypeExternalizerNoId() throws Exception {
        ObjectInOut inOutOrig = new ObjectInOut();
        MediaType.MediaTypeExternalizer mediaTypeExternalizer = new MediaType.MediaTypeExternalizer();
        mediaTypeExternalizer.writeObject((ObjectOutput)inOutOrig, MediaType.APPLICATION_XML);
        MediaType mediaType = mediaTypeExternalizer.readObject((ObjectInput)inOutOrig);
        this.assertMediaTypeNoParams(mediaType, "application", "xml");
    }

    @Test
    public void testMediaTypeExternalizerId() throws Exception {
        ObjectInOut inOutOrig = new ObjectInOut();
        MediaType.MediaTypeExternalizer mediaTypeExternalizer = new MediaType.MediaTypeExternalizer();
        mediaTypeExternalizer.writeObject((ObjectOutput)inOutOrig, MediaType.TEXT_PLAIN);
        MediaType mediaType = mediaTypeExternalizer.readObject((ObjectInput)inOutOrig);
        this.assertMediaTypeNoParams(mediaType, "text", "plain");
    }

    private void assertMediaTypeNoParams(MediaType mediaType, String type, String subType) {
        Assert.assertEquals((Object)type, (Object)mediaType.getType());
        Assert.assertEquals((Object)subType, (Object)mediaType.getSubType());
        Assert.assertFalse((boolean)mediaType.hasParameters());
        Assert.assertEquals(Optional.empty(), (Object)mediaType.getParameter("a"));
    }

    private void assertMediaTypeWithParam(MediaType mediaType, String type, String subType, String paramName, String paramValue) {
        this.assertMediaTypeWithParams(mediaType, type, subType, new String[]{paramName}, new String[]{paramValue});
    }

    private void assertMediaTypeWithParams(MediaType mediaType, String type, String subType, String[] paramNames, String[] paramValues) {
        Assert.assertEquals((Object)type, (Object)mediaType.getType());
        Assert.assertEquals((Object)subType, (Object)mediaType.getSubType());
        Assert.assertTrue((boolean)mediaType.hasParameters());
        for (int i = 0; i < paramNames.length; ++i) {
            String paramName = paramNames[i];
            String paramValue = paramValues[i];
            Assert.assertEquals(Optional.of(paramValue), (Object)mediaType.getParameter(paramName));
        }
    }

    private static Map<String, String> createMap(MapEntry ... entries) {
        HashMap<String, String> map = new HashMap<String, String>();
        Arrays.stream(entries).forEach(e -> map.put(e.getKey(), e.getValue()));
        return map;
    }

    private static class ObjectInOut
    implements ObjectInput,
    ObjectOutput {
        private final Queue<Object> buffer = new LinkedList<Object>();

        private ObjectInOut() {
        }

        @Override
        public Object readObject() throws ClassNotFoundException, IOException {
            return this.buffer.poll();
        }

        @Override
        public int read() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int read(byte[] b) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long skip(long n) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int available() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeObject(Object obj) throws IOException {
            this.buffer.add(obj);
        }

        @Override
        public void write(int b) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void write(byte[] b) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeBoolean(boolean v) throws IOException {
            this.buffer.add(v);
        }

        @Override
        public void writeByte(int v) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeShort(int v) throws IOException {
            this.buffer.add((short)v);
        }

        @Override
        public void writeChar(int v) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeInt(int v) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeLong(long v) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeFloat(float v) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeDouble(double v) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeBytes(String s) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeChars(String s) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeUTF(String s) throws IOException {
            this.buffer.add(s);
        }

        @Override
        public void flush() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void readFully(byte[] b) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void readFully(byte[] b, int off, int len) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int skipBytes(int n) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean readBoolean() throws IOException {
            return (Boolean)this.buffer.poll();
        }

        @Override
        public byte readByte() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int readUnsignedByte() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public short readShort() throws IOException {
            return (Short)this.buffer.poll();
        }

        @Override
        public int readUnsignedShort() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public char readChar() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int readInt() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long readLong() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public float readFloat() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public double readDouble() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public String readLine() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public String readUTF() throws IOException {
            return (String)this.buffer.poll();
        }
    }

    private class MapEntry {
        private String key;
        private String value;

        String getKey() {
            return this.key;
        }

        String getValue() {
            return this.value;
        }

        MapEntry(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }
}

