/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.PrimitiveIterator;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.RangeSet;
import org.infinispan.commons.util.SmallIntSet;
import org.junit.Assert;
import org.junit.Test;

public class SmallIntSetTest {
    @Test
    public void testSize() {
        SmallIntSet sis = new SmallIntSet();
        sis.add(1);
        sis.add(4);
        Assert.assertEquals((long)2L, (long)sis.size());
        sis.add(4);
        Assert.assertEquals((long)2L, (long)sis.size());
    }

    @Test
    public void testIsEmpty() {
        SmallIntSet sis = new SmallIntSet();
        Assert.assertTrue((boolean)sis.isEmpty());
        sis.add(1);
        sis.add(4);
        Assert.assertFalse((boolean)sis.isEmpty());
    }

    @Test
    public void contains() throws Exception {
        SmallIntSet sis = new SmallIntSet();
        Assert.assertFalse((boolean)sis.contains(1));
        sis.add(1);
        Assert.assertTrue((boolean)sis.contains(1));
    }

    @Test
    public void contains1() throws Exception {
        SmallIntSet sis = new SmallIntSet();
        Integer intValue = 1;
        Assert.assertFalse((boolean)sis.contains(intValue));
        sis.add(1);
        Assert.assertTrue((boolean)sis.contains(intValue));
    }

    @Test
    public void iterator() throws Exception {
        SmallIntSet sis = new SmallIntSet();
        sis.add(1);
        sis.add(4);
        PrimitiveIterator.OfInt iterator = sis.iterator();
        Assert.assertEquals((long)1L, (long)iterator.nextInt());
        Assert.assertEquals((long)4L, (long)iterator.nextInt());
    }

    @Test
    public void toArray() throws Exception {
        SmallIntSet sis = new SmallIntSet();
        sis.add(1);
        sis.add(4);
        Object[] array = sis.toArray();
        Assert.assertEquals((long)2L, (long)array.length);
        Assert.assertEquals((Object)1, (Object)array[0]);
        Assert.assertEquals((Object)4, (Object)array[1]);
    }

    @Test
    public void toArray1() throws Exception {
        SmallIntSet sis = new SmallIntSet();
        sis.add(1);
        sis.add(4);
        Object[] array = sis.toArray((Object[])new Integer[2]);
        Assert.assertEquals((long)2L, (long)array.length);
        Assert.assertEquals((Object)1, (Object)array[0]);
        Assert.assertEquals((Object)4, (Object)array[1]);
    }

    @Test
    public void add() throws Exception {
        SmallIntSet sis = new SmallIntSet();
        Assert.assertTrue((boolean)sis.add(1));
        Assert.assertFalse((boolean)sis.add(1));
    }

    @Test
    public void add1() throws Exception {
        SmallIntSet sis = new SmallIntSet();
        Assert.assertTrue((boolean)sis.add(Integer.valueOf(1)));
        Assert.assertFalse((boolean)sis.add(Integer.valueOf(1)));
    }

    @Test
    public void set() throws Exception {
        SmallIntSet sis = new SmallIntSet();
        sis.set(1);
        Assert.assertTrue((boolean)sis.contains(1));
    }

    @Test
    public void remove() throws Exception {
        SmallIntSet sis = new SmallIntSet();
        Assert.assertFalse((boolean)sis.remove(1));
        sis.add(1);
        Assert.assertTrue((boolean)sis.remove(1));
    }

    @Test
    public void remove1() throws Exception {
        SmallIntSet sis = new SmallIntSet();
        Assert.assertFalse((boolean)sis.remove((Object)1));
        sis.add(1);
        Assert.assertTrue((boolean)sis.remove((Object)1));
    }

    @Test
    public void containsAll() throws Exception {
        SmallIntSet sis1 = new SmallIntSet();
        SmallIntSet sis2 = new SmallIntSet();
        sis1.add(1);
        sis1.add(4);
        sis2.add(1);
        sis2.add(4);
        sis2.add(7);
        Assert.assertFalse((boolean)sis1.containsAll((IntSet)sis2));
        Assert.assertTrue((boolean)sis2.containsAll((IntSet)sis1));
    }

    @Test
    public void containsAll1() throws Exception {
        SmallIntSet sis1 = new SmallIntSet();
        HashSet<Integer> sis2 = new HashSet<Integer>();
        sis1.add(1);
        sis1.add(4);
        sis2.add(1);
        sis2.add(4);
        sis2.add(7);
        Assert.assertFalse((boolean)sis1.containsAll(sis2));
        Assert.assertTrue((boolean)sis2.containsAll((Collection<?>)sis1));
    }

    @Test
    public void addAll() throws Exception {
        SmallIntSet sis1 = new SmallIntSet();
        sis1.add(1);
        sis1.add(4);
        SmallIntSet sis2 = new SmallIntSet();
        sis2.addAll((IntSet)sis1);
        Assert.assertEquals((long)2L, (long)sis2.size());
    }

    @Test
    public void addAll1() throws Exception {
        RangeSet intSet = new RangeSet(4);
        SmallIntSet sis = new SmallIntSet();
        sis.addAll((IntSet)intSet);
        Assert.assertEquals((long)4L, (long)sis.size());
    }

    @Test
    public void addAll2() throws Exception {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(1);
        hashSet.add(4);
        SmallIntSet sis = new SmallIntSet();
        sis.addAll(hashSet);
        Assert.assertEquals((long)2L, (long)sis.size());
    }

    @Test
    public void removeAll() throws Exception {
        SmallIntSet sis1 = new SmallIntSet();
        sis1.add(1);
        sis1.add(4);
        sis1.add(7);
        Assert.assertEquals((long)3L, (long)sis1.size());
        SmallIntSet sis2 = new SmallIntSet();
        sis2.add(4);
        sis2.add(5);
        sis2.add(7);
        sis1.removeAll((IntSet)sis2);
        Assert.assertEquals((long)1L, (long)sis1.size());
        Assert.assertTrue((boolean)sis1.contains(1));
    }

    @Test
    public void removeAll1() throws Exception {
        SmallIntSet sis1 = new SmallIntSet();
        sis1.add(1);
        sis1.add(4);
        sis1.add(7);
        Assert.assertEquals((long)3L, (long)sis1.size());
        RangeSet intSet = new RangeSet(5);
        sis1.removeAll((IntSet)intSet);
        Assert.assertEquals((long)1L, (long)sis1.size());
        Assert.assertTrue((boolean)sis1.contains(7));
    }

    @Test
    public void removeAll2() throws Exception {
        SmallIntSet sis1 = new SmallIntSet();
        sis1.add(1);
        sis1.add(4);
        sis1.add(7);
        Assert.assertEquals((long)3L, (long)sis1.size());
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(4);
        hashSet.add(5);
        hashSet.add(7);
        sis1.removeAll(hashSet);
        Assert.assertEquals((long)1L, (long)sis1.size());
        Assert.assertTrue((boolean)sis1.contains(1));
    }

    @Test
    public void retainAll() throws Exception {
        SmallIntSet sis1 = new SmallIntSet();
        sis1.add(1);
        sis1.add(4);
        sis1.add(7);
        Assert.assertEquals((long)3L, (long)sis1.size());
        SmallIntSet sis2 = new SmallIntSet();
        sis2.add(4);
        sis2.add(5);
        sis2.add(7);
        sis1.retainAll((IntSet)sis2);
        Assert.assertEquals((long)2L, (long)sis1.size());
        Assert.assertTrue((boolean)sis1.contains(4));
        Assert.assertTrue((boolean)sis1.contains(7));
    }

    @Test
    public void retainAll1() throws Exception {
        SmallIntSet sis1 = new SmallIntSet();
        sis1.add(1);
        sis1.add(4);
        sis1.add(7);
        Assert.assertEquals((long)3L, (long)sis1.size());
        RangeSet intSet = new RangeSet(5);
        sis1.retainAll((IntSet)intSet);
        Assert.assertEquals((long)2L, (long)sis1.size());
        Assert.assertTrue((boolean)sis1.contains(1));
        Assert.assertTrue((boolean)sis1.contains(4));
    }

    @Test
    public void retainAll2() throws Exception {
        SmallIntSet sis1 = new SmallIntSet();
        sis1.add(1);
        sis1.add(4);
        sis1.add(7);
        Assert.assertEquals((long)3L, (long)sis1.size());
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(4);
        hashSet.add(5);
        hashSet.add(7);
        sis1.retainAll(hashSet);
        Assert.assertEquals((long)2L, (long)sis1.size());
        Assert.assertTrue((boolean)sis1.contains(4));
        Assert.assertTrue((boolean)sis1.contains(7));
    }

    @Test
    public void clear() throws Exception {
        SmallIntSet sis = new SmallIntSet();
        sis.add(1);
        sis.add(4);
        sis.add(7);
        Assert.assertEquals((long)3L, (long)sis.size());
        sis.clear();
        Assert.assertEquals((long)0L, (long)sis.size());
    }

    @Test
    public void intStream() throws Exception {
        SmallIntSet sis = new SmallIntSet();
        sis.add(1);
        sis.add(4);
        sis.add(7);
        Assert.assertEquals((long)12L, (long)sis.intStream().sum());
    }

    @Test
    public void equals() throws Exception {
        SmallIntSet sis1 = new SmallIntSet();
        sis1.add(1);
        sis1.add(4);
        sis1.add(7);
        SmallIntSet sis2 = new SmallIntSet();
        sis2.add(1);
        sis2.add(4);
        Assert.assertNotEquals((Object)sis1, (Object)sis2);
        Assert.assertNotEquals((Object)sis2, (Object)sis1);
        sis2.add(7);
        Assert.assertEquals((Object)sis1, (Object)sis2);
        Assert.assertEquals((Object)sis2, (Object)sis1);
    }

    @Test
    public void equals1() throws Exception {
        SmallIntSet sis = new SmallIntSet();
        sis.add(0);
        sis.add(1);
        sis.add(2);
        RangeSet intSet = new RangeSet(4);
        Assert.assertNotEquals((Object)sis, (Object)intSet);
        Assert.assertNotEquals((Object)intSet, (Object)sis);
        sis.add(3);
        Assert.assertEquals((Object)sis, (Object)intSet);
        Assert.assertEquals((Object)intSet, (Object)sis);
    }

    @Test
    public void equals2() throws Exception {
        SmallIntSet sis = new SmallIntSet();
        sis.add(1);
        sis.add(4);
        sis.add(7);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(1);
        hashSet.add(4);
        Assert.assertNotEquals((Object)sis, hashSet);
        Assert.assertNotEquals(hashSet, (Object)sis);
        hashSet.add(7);
        Assert.assertEquals((Object)sis, hashSet);
        Assert.assertEquals(hashSet, (Object)sis);
    }
}

