/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.IntConsumer;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.commons.util.ConcurrentSmallIntSet;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.RangeSet;
import org.infinispan.commons.util.SmallIntSet;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class MutableIntSetTest {
    @Parameterized.Parameter
    public IntSet intSet;

    @Parameterized.Parameters
    public static Object[] data() {
        return new Object[]{new SmallIntSet(), new ConcurrentSmallIntSet(16)};
    }

    @After
    public void after() {
        this.intSet.clear();
    }

    @Test
    public void testSize() {
        this.intSet.add(1);
        this.intSet.add(4);
        Assert.assertEquals((long)2L, (long)this.intSet.size());
        this.intSet.add(4);
        Assert.assertEquals((long)2L, (long)this.intSet.size());
    }

    @Test
    public void testIsEmpty() {
        Assert.assertTrue((boolean)this.intSet.isEmpty());
        this.intSet.add(1);
        this.intSet.add(4);
        Assert.assertFalse((boolean)this.intSet.isEmpty());
    }

    @Test
    public void testContains() throws Exception {
        Assert.assertFalse((boolean)this.intSet.contains(1));
        this.intSet.add(1);
        Assert.assertTrue((boolean)this.intSet.contains(1));
        Assert.assertFalse((boolean)this.intSet.contains(1832131));
    }

    @Test
    public void testContains1() throws Exception {
        Integer intValue = 1;
        Assert.assertFalse((boolean)this.intSet.contains((Object)intValue));
        this.intSet.add(1);
        Assert.assertTrue((boolean)this.intSet.contains((Object)intValue));
        Assert.assertFalse((boolean)this.intSet.contains(1832131));
    }

    @Test
    public void testIterator() throws Exception {
        this.intSet.add(1);
        this.intSet.add(4);
        PrimitiveIterator.OfInt iterator = this.intSet.iterator();
        Assert.assertEquals((long)1L, (long)iterator.nextInt());
        Assert.assertEquals((long)4L, (long)iterator.nextInt());
    }

    @Test
    public void testToIntArray() throws Exception {
        this.intSet.add(1);
        this.intSet.add(4);
        int[] array = this.intSet.toIntArray();
        Assert.assertArrayEquals((int[])new int[]{1, 4}, (int[])array);
    }

    @Test
    public void testToArray() throws Exception {
        this.intSet.add(1);
        this.intSet.add(4);
        Object[] array = this.intSet.toArray();
        Assert.assertArrayEquals((Object[])new Object[]{1, 4}, (Object[])array);
    }

    @Test
    public void testToArray1() throws Exception {
        this.intSet.add(1);
        this.intSet.add(4);
        Object[] array = (Integer[])this.intSet.toArray((Object[])new Integer[2]);
        Assert.assertArrayEquals((Object[])new Integer[]{1, 4}, (Object[])array);
    }

    @Test
    public void testAdd() throws Exception {
        Assert.assertTrue((boolean)this.intSet.add(1));
        Assert.assertFalse((boolean)this.intSet.add(1));
    }

    @Test
    public void testAdd1() throws Exception {
        Assert.assertTrue((boolean)this.intSet.add((Object)1));
        Assert.assertFalse((boolean)this.intSet.add((Object)1));
    }

    @Test
    public void testSet() throws Exception {
        this.intSet.set(1);
        Assert.assertTrue((boolean)this.intSet.contains(1));
    }

    @Test
    public void testRemove() throws Exception {
        Assert.assertFalse((boolean)this.intSet.remove(1));
        this.intSet.add(1);
        Assert.assertTrue((boolean)this.intSet.remove(1));
    }

    @Test
    public void testRemove1() throws Exception {
        Assert.assertFalse((boolean)this.intSet.remove((Object)1));
        this.intSet.add(1);
        Assert.assertTrue((boolean)this.intSet.remove((Object)1));
    }

    @Test
    public void testContainsAll() throws Exception {
        SmallIntSet intSet2 = new SmallIntSet();
        this.intSet.add(1);
        this.intSet.add(4);
        intSet2.add(1);
        intSet2.add(4);
        intSet2.add(7);
        Assert.assertFalse((boolean)this.intSet.containsAll((IntSet)intSet2));
        Assert.assertTrue((boolean)intSet2.containsAll(this.intSet));
    }

    @Test
    public void testContainsAll1() throws Exception {
        this.intSet.add(1);
        this.intSet.add(4);
        Set set = CollectionFactory.makeSet((Object[])new Integer[]{1, 4, 7});
        Assert.assertFalse((boolean)this.intSet.containsAll((Collection)set));
        Assert.assertTrue((boolean)set.containsAll((Collection<?>)this.intSet));
    }

    @Test
    public void testAddAll() throws Exception {
        this.intSet.add(1);
        this.intSet.add(4);
        SmallIntSet intSet2 = new SmallIntSet();
        intSet2.addAll(this.intSet);
        Assert.assertEquals((long)2L, (long)intSet2.size());
    }

    @Test
    public void testAddAll1() throws Exception {
        RangeSet rangeSet = new RangeSet(4);
        this.intSet.addAll((IntSet)rangeSet);
        Assert.assertEquals((long)4L, (long)this.intSet.size());
    }

    @Test
    public void testAddAll2() throws Exception {
        this.intSet.addAll((Collection)CollectionFactory.makeSet((Object[])new Integer[]{1, 4}));
        Assert.assertEquals((long)2L, (long)this.intSet.size());
    }

    @Test
    public void testRemoveAll() throws Exception {
        this.intSet.add(1);
        this.intSet.add(4);
        this.intSet.add(7);
        Assert.assertEquals((long)3L, (long)this.intSet.size());
        SmallIntSet intSet2 = new SmallIntSet();
        intSet2.add(4);
        intSet2.add(5);
        intSet2.add(7);
        Assert.assertTrue((boolean)this.intSet.removeAll((IntSet)intSet2));
        Assert.assertEquals((long)1L, (long)this.intSet.size());
        Assert.assertTrue((boolean)this.intSet.contains(1));
    }

    @Test
    public void testRemoveAll1() throws Exception {
        this.intSet.add(1);
        this.intSet.add(4);
        this.intSet.add(7);
        Assert.assertEquals((long)3L, (long)this.intSet.size());
        RangeSet rs = new RangeSet(5);
        Assert.assertTrue((boolean)this.intSet.removeAll((IntSet)rs));
        Assert.assertEquals((Object)CollectionFactory.makeSet((Object[])new Object[]{7}), (Object)this.intSet);
    }

    @Test
    public void testRemoveAll2() throws Exception {
        this.intSet.add(1);
        this.intSet.add(4);
        this.intSet.add(7);
        Assert.assertEquals((long)3L, (long)this.intSet.size());
        Assert.assertTrue((boolean)this.intSet.removeAll((Collection)CollectionFactory.makeSet((Object[])new Integer[]{4, 5, 7})));
        Assert.assertEquals((Object)CollectionFactory.makeSet((Object[])new Object[]{1}), (Object)this.intSet);
    }

    @Test
    public void testRetainAll() throws Exception {
        this.intSet.add(1);
        this.intSet.add(4);
        this.intSet.add(7);
        Assert.assertEquals((long)3L, (long)this.intSet.size());
        SmallIntSet intSet2 = new SmallIntSet();
        intSet2.add(4);
        intSet2.add(5);
        intSet2.add(7);
        this.intSet.retainAll((IntSet)intSet2);
        Assert.assertEquals((Object)CollectionFactory.makeSet((Object[])new Integer[]{4, 7}), (Object)this.intSet);
    }

    @Test
    public void testRetainAll1() throws Exception {
        this.intSet.add(1);
        this.intSet.add(4);
        this.intSet.add(7);
        Assert.assertEquals((long)3L, (long)this.intSet.size());
        RangeSet rs = new RangeSet(5);
        Assert.assertTrue((boolean)this.intSet.retainAll((IntSet)rs));
        Assert.assertEquals((Object)CollectionFactory.makeSet((Object[])new Integer[]{1, 4}), (Object)this.intSet);
    }

    @Test
    public void testRetainAll2() throws Exception {
        this.intSet.add(1);
        this.intSet.add(4);
        this.intSet.add(7);
        Assert.assertEquals((long)3L, (long)this.intSet.size());
        Assert.assertTrue((boolean)this.intSet.retainAll((Collection)CollectionFactory.makeSet((Object[])new Integer[]{4, 5, 7})));
        Assert.assertEquals((Object)CollectionFactory.makeSet((Object[])new Integer[]{4, 7}), (Object)this.intSet);
    }

    @Test
    public void testClear() throws Exception {
        this.intSet.add(1);
        this.intSet.add(4);
        this.intSet.add(7);
        Assert.assertEquals((long)3L, (long)this.intSet.size());
        this.intSet.clear();
        Assert.assertEquals((long)0L, (long)this.intSet.size());
    }

    @Test
    public void testIntStream() throws Exception {
        this.intSet.add(1);
        this.intSet.add(4);
        this.intSet.add(7);
        Assert.assertEquals((long)12L, (long)this.intSet.intStream().sum());
    }

    @Test
    public void testEquals() throws Exception {
        this.intSet.add(1);
        this.intSet.add(4);
        this.intSet.add(7);
        SmallIntSet intSet2 = new SmallIntSet();
        intSet2.add(1);
        intSet2.add(4);
        Assert.assertNotEquals((Object)this.intSet, (Object)intSet2);
        Assert.assertNotEquals((Object)intSet2, (Object)this.intSet);
        intSet2.add(7);
        Assert.assertEquals((Object)this.intSet, (Object)intSet2);
        Assert.assertEquals((Object)intSet2, (Object)this.intSet);
    }

    @Test
    public void testEquals1() throws Exception {
        this.intSet.add(0);
        this.intSet.add(1);
        this.intSet.add(2);
        RangeSet rangeSet = new RangeSet(4);
        Assert.assertNotEquals((Object)rangeSet, (Object)this.intSet);
        Assert.assertNotEquals((Object)this.intSet, (Object)rangeSet);
        this.intSet.add(3);
        Assert.assertEquals((Object)this.intSet, (Object)this.intSet);
        Assert.assertEquals((Object)this.intSet, (Object)this.intSet);
    }

    @Test
    public void testEquals2() throws Exception {
        this.intSet.add(1);
        this.intSet.add(4);
        this.intSet.add(7);
        Set hashSet = CollectionFactory.makeSet((Object[])new Integer[]{1, 4});
        Assert.assertNotEquals((Object)this.intSet, (Object)hashSet);
        Assert.assertNotEquals((Object)hashSet, (Object)this.intSet);
        hashSet.add(7);
        Assert.assertEquals((Object)this.intSet, (Object)hashSet);
        Assert.assertEquals((Object)hashSet, (Object)this.intSet);
    }

    @Test
    public void testForEachPrimitive() {
        this.intSet.add(0);
        this.intSet.add(4);
        this.intSet.add(7);
        HashSet results = new HashSet();
        this.intSet.forEach(results::add);
        Assert.assertEquals((Object)CollectionFactory.makeSet((Object[])new Integer[]{0, 4, 7}), results);
    }

    @Test
    public void testForEachObject() {
        this.intSet.add(0);
        this.intSet.add(4);
        this.intSet.add(7);
        HashSet results = new HashSet();
        this.intSet.forEach(results::add);
        Assert.assertEquals((Object)CollectionFactory.makeSet((Object[])new Integer[]{0, 4, 7}), results);
    }

    @Test
    public void testRemoveIfPrimitive() {
        this.intSet.add(1);
        this.intSet.add(4);
        this.intSet.add(7);
        Assert.assertFalse((boolean)this.intSet.removeIf(i -> i / 10 > 0));
        Assert.assertEquals((long)3L, (long)this.intSet.size());
        Assert.assertTrue((boolean)this.intSet.removeIf(i -> i > 3));
        Assert.assertEquals((Object)CollectionFactory.makeSet((Object[])new Object[]{1}), (Object)this.intSet);
    }

    @Test
    public void testRemoveIfObject() {
        this.intSet.add(1);
        this.intSet.add(4);
        this.intSet.add(7);
        Assert.assertFalse((boolean)this.intSet.removeIf(i -> i / 10 > 0));
        Assert.assertEquals((long)3L, (long)this.intSet.size());
        Assert.assertTrue((boolean)this.intSet.removeIf(i -> i > 3));
        Assert.assertEquals((Object)CollectionFactory.makeSet((Object[])new Object[]{1}), (Object)this.intSet);
    }

    @Test
    public void testIntSpliteratorForEachRemaining() {
        this.intSet.add(1);
        this.intSet.add(4);
        this.intSet.add(7);
        HashSet results = new HashSet();
        this.intSet.intSpliterator().forEachRemaining(results::add);
        Assert.assertEquals((Object)CollectionFactory.makeSet((Object[])new Integer[]{1, 4, 7}), results);
    }

    @Test
    public void testIntSpliteratorSplitTryAdvance() {
        this.intSet.add(1);
        this.intSet.add(4);
        this.intSet.add(7);
        HashSet results = new HashSet();
        Spliterator.OfInt spliterator = this.intSet.intSpliterator();
        Spliterator.OfInt split = spliterator.trySplit();
        Assert.assertNotNull((Object)split);
        IntConsumer consumer = results::add;
        while (spliterator.tryAdvance(consumer)) {
        }
        while (split.tryAdvance(consumer)) {
        }
        Assert.assertEquals((Object)CollectionFactory.makeSet((Object[])new Integer[]{1, 4, 7}), results);
    }
}

